/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.datastructures;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.bdds.datastructures.BDDNode;

public final class BDDInnerNode
implements BDDNode {
    private final Variable var;
    private final BDDNode low;
    private final BDDNode high;

    public BDDInnerNode(Variable var, BDDNode low, BDDNode high) {
        this.var = var;
        this.low = low;
        this.high = high;
    }

    @Override
    public Variable label() {
        return this.var;
    }

    @Override
    public boolean isInnerNode() {
        return true;
    }

    @Override
    public BDDNode low() {
        return this.low;
    }

    @Override
    public BDDNode high() {
        return this.high;
    }

    @Override
    public Set<BDDNode> nodes() {
        HashSet<BDDNode> res = new HashSet<BDDNode>(Collections.singleton(this));
        res.addAll(this.low.nodes());
        res.addAll(this.high.nodes());
        return res;
    }

    public int hashCode() {
        return Objects.hash(this.var, this.low, this.high);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BDDInnerNode) {
            BDDInnerNode o = (BDDInnerNode)other;
            return Objects.equals(this.var, o.var) && Objects.equals(this.low, o.low) && Objects.equals(this.high, o.high);
        }
        return false;
    }

    public String toString() {
        return "<" + this.var + " | low=" + this.low + " high=" + this.high + ">";
    }
}

