/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.datastructures;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.logicng.formulas.Constant;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.knowledgecompilation.bdds.datastructures.BDDNode;

public final class BDDConstant
implements BDDNode {
    private final Constant value;

    private BDDConstant(Constant value) {
        this.value = value;
    }

    public static BDDConstant getFalsumNode(FormulaFactory f) {
        return new BDDConstant(f.falsum());
    }

    public static BDDConstant getVerumNode(FormulaFactory f) {
        return new BDDConstant(f.verum());
    }

    @Override
    public Formula label() {
        return this.value;
    }

    @Override
    public boolean isInnerNode() {
        return false;
    }

    @Override
    public BDDNode low() {
        return null;
    }

    @Override
    public BDDNode high() {
        return null;
    }

    @Override
    public Set<BDDNode> nodes() {
        return new HashSet<BDDNode>(Collections.singletonList(this));
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof BDDConstant && Objects.equals(this.value, ((BDDConstant)other).value);
    }

    public String toString() {
        return "<" + this.value + ">";
    }
}

