/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds;

import java.util.Iterator;
import org.logicng.formulas.And;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Implication;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Not;
import org.logicng.handlers.BDDHandler;
import org.logicng.knowledgecompilation.bdds.BDD;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDConstruction;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;

public final class BDDFactory {
    private BDDFactory() {
    }

    public static BDD build(Formula formula) {
        return BDDFactory.build(formula, null, null);
    }

    public static BDD build(Formula formula, BDDKernel kernel) {
        return BDDFactory.build(formula, kernel, null);
    }

    public static BDD build(Formula formula, BDDKernel kernel, BDDHandler handler) {
        if (handler != null) {
            handler.started();
        }
        int varNum = formula.variables().size();
        BDDKernel bddKernel = kernel == null ? new BDDKernel(formula.factory(), varNum, varNum * 30, varNum * 20) : kernel;
        return new BDD(BDDFactory.buildRec(formula, bddKernel, new BDDConstruction(bddKernel), handler), bddKernel);
    }

    private static int buildRec(Formula formula, BDDKernel kernel, BDDConstruction construction, BDDHandler handler) {
        switch (formula.type()) {
            case FALSE: {
                return 0;
            }
            case TRUE: {
                return 1;
            }
            case LITERAL: {
                Literal lit = (Literal)formula;
                int idx = kernel.getOrAddVarIndex(lit.variable());
                return lit.phase() ? construction.ithVar(idx) : construction.nithVar(idx);
            }
            case NOT: {
                Not not = (Not)formula;
                int operand = BDDFactory.buildRec(not.operand(), kernel, construction, handler);
                if (operand == -1) {
                    return -1;
                }
                int res = kernel.addRef(construction.not(operand), handler);
                kernel.delRef(operand);
                return res;
            }
            case IMPL: 
            case EQUIV: {
                BinaryOperator binary = (BinaryOperator)formula;
                int left = BDDFactory.buildRec(binary.left(), kernel, construction, handler);
                if (left == -1) {
                    return -1;
                }
                int right = BDDFactory.buildRec(binary.right(), kernel, construction, handler);
                if (right == -1) {
                    return -1;
                }
                int res = kernel.addRef(binary instanceof Implication ? construction.implication(left, right) : construction.equivalence(left, right), handler);
                kernel.delRef(left);
                kernel.delRef(right);
                return res;
            }
            case AND: 
            case OR: {
                Iterator it = formula.iterator();
                int res = BDDFactory.buildRec((Formula)it.next(), kernel, construction, handler);
                if (res == -1) {
                    return -1;
                }
                while (it.hasNext()) {
                    int operand = BDDFactory.buildRec((Formula)it.next(), kernel, construction, handler);
                    if (operand == -1) {
                        return -1;
                    }
                    int previous = res;
                    res = formula instanceof And ? kernel.addRef(construction.and(res, operand), handler) : kernel.addRef(construction.or(res, operand), handler);
                    kernel.delRef(previous);
                    kernel.delRef(operand);
                }
                return res;
            }
            case PBC: {
                return BDDFactory.buildRec(formula.nnf(), kernel, construction, handler);
            }
        }
        throw new IllegalArgumentException("Unsupported operator for BDD generation: " + (Object)((Object)formula.type()));
    }
}

