/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.bdds.BDDFactory;
import org.logicng.knowledgecompilation.bdds.datastructures.BDDNode;
import org.logicng.knowledgecompilation.bdds.functions.BDDCNFFunction;
import org.logicng.knowledgecompilation.bdds.functions.BDDFunction;
import org.logicng.knowledgecompilation.bdds.functions.BDDModelEnumerationFunction;
import org.logicng.knowledgecompilation.bdds.functions.LngBDDFunction;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDConstruction;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDOperations;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDReordering;

public final class BDD {
    private final int index;
    protected final BDDKernel kernel;
    protected final BDDConstruction construction;
    protected final BDDOperations operations;

    public BDD(int index, BDDKernel kernel) {
        this.index = index;
        this.kernel = kernel;
        this.construction = new BDDConstruction(kernel);
        this.operations = new BDDOperations(kernel);
    }

    public int index() {
        return this.index;
    }

    public BDDKernel underlyingKernel() {
        return this.kernel;
    }

    public <T> T apply(BDDFunction<T> function) {
        return function.apply(this);
    }

    public boolean isTautology() {
        return this.index == 1;
    }

    public boolean isContradiction() {
        return this.index == 0;
    }

    public BigInteger modelCount() {
        return this.operations.satCount(this.index);
    }

    public List<Assignment> enumerateAllModels() {
        return this.enumerateAllModels((Collection<Variable>)null);
    }

    public List<Assignment> enumerateAllModels(Variable ... variables) {
        return this.enumerateAllModels(Arrays.asList(variables));
    }

    public List<Assignment> enumerateAllModels(Collection<Variable> variables) {
        return this.apply(new BDDModelEnumerationFunction(variables));
    }

    public Formula cnf() {
        return this.apply(new BDDCNFFunction());
    }

    public BigInteger numberOfClausesCNF() {
        return this.operations.pathCountZero(this.index);
    }

    public Formula dnf() {
        ArrayList<Formula> ops = new ArrayList<Formula>();
        FormulaFactory f = this.kernel.factory();
        for (Assignment ass : this.enumerateAllModels()) {
            ops.add(ass.formula(f));
        }
        return ops.isEmpty() ? f.falsum() : f.or(ops);
    }

    public BDD restrict(Collection<Literal> restriction) {
        BDD resBDD = BDDFactory.build(this.kernel.factory().and(restriction), this.kernel, null);
        return new BDD(this.construction.restrict(this.index, resBDD.index), this.kernel);
    }

    public BDD restrict(Literal ... restriction) {
        return this.restrict(Arrays.asList(restriction));
    }

    public BDD exists(Collection<Variable> variables) {
        BDD resBDD = BDDFactory.build(this.kernel.factory().and(variables), this.kernel);
        return new BDD(this.construction.exists(this.index, resBDD.index), this.kernel);
    }

    public BDD exists(Variable ... variables) {
        return this.exists(Arrays.asList(variables));
    }

    public BDD forall(Collection<Variable> variables) {
        BDD resBDD = BDDFactory.build(this.kernel.factory().and(variables), this.kernel);
        return new BDD(this.construction.forAll(this.index, resBDD.index), this.kernel);
    }

    public BDD forall(Variable ... variables) {
        return this.forall(Arrays.asList(variables));
    }

    public Assignment model() {
        return this.createAssignment(this.operations.satOne(this.index));
    }

    public Assignment model(boolean defaultValue, Collection<Variable> variables) {
        int varBDD = BDDFactory.build((Formula)this.kernel.factory().and(variables), (BDDKernel)this.kernel, null).index;
        int pol = defaultValue ? 1 : 0;
        int modelBDD = this.operations.satOneSet(this.index, varBDD, pol);
        return this.createAssignment(modelBDD);
    }

    public Assignment model(boolean defaultValue, Variable ... variables) {
        return this.model(defaultValue, Arrays.asList(variables));
    }

    public Assignment fullModel() {
        return this.createAssignment(this.operations.fullSatOne(this.index));
    }

    public BigInteger pathCountOne() {
        return this.operations.pathCountOne(this.index);
    }

    public BigInteger pathCountZero() {
        return this.operations.pathCountZero(this.index);
    }

    public SortedSet<Variable> support() {
        int supportBDD = this.operations.support(this.index);
        Assignment assignment = this.createAssignment(supportBDD);
        assert (assignment == null || assignment.negativeLiterals().isEmpty());
        return assignment == null ? Collections.emptySortedSet() : new TreeSet<Variable>(assignment.positiveVariables());
    }

    public int nodeCount() {
        return this.operations.nodeCount(this.index);
    }

    public SortedMap<Variable, Integer> variableProfile() {
        int[] varProfile = this.operations.varProfile(this.index);
        TreeMap<Variable, Integer> profile = new TreeMap<Variable, Integer>();
        for (int i = 0; i < varProfile.length; ++i) {
            profile.put(this.kernel.getVariableForIndex(i), varProfile[i]);
        }
        return profile;
    }

    public List<Variable> getVariableOrder() {
        ArrayList<Variable> order = new ArrayList<Variable>();
        for (int i : this.kernel.getCurrentVarOrder()) {
            order.add(this.kernel.getVariableForIndex(i));
        }
        return order;
    }

    public void swapVariables(Variable first, Variable second) {
        int firstVar = this.kernel.getIndexForVariable(first);
        int secondVar = this.kernel.getIndexForVariable(second);
        if (firstVar < 0) {
            throw new IllegalArgumentException("Unknown variable: " + first);
        }
        if (secondVar < 0) {
            throw new IllegalArgumentException("Unknown variable: " + second);
        }
        this.kernel.getReordering().swapVariables(firstVar, secondVar);
    }

    public BDDReordering getReordering() {
        return this.kernel.getReordering();
    }

    public BDDNode toLngBdd() {
        return this.apply(new LngBDDFunction());
    }

    private Assignment createAssignment(int modelBDD) {
        if (modelBDD == 0) {
            return null;
        }
        if (modelBDD == 1) {
            return new Assignment();
        }
        List<int[]> nodes = this.operations.allNodes(modelBDD);
        Assignment assignment = new Assignment();
        for (int[] node : nodes) {
            Variable variable = this.kernel.getVariableForIndex(node[1]);
            if (node[2] == 0) {
                assignment.addLiteral(variable);
                continue;
            }
            if (node[3] == 0) {
                assignment.addLiteral(variable.negate());
                continue;
            }
            throw new IllegalStateException("Expected that the model BDD has one unique path through the BDD.");
        }
        return assignment;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.kernel);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof BDD && this.index == ((BDD)other).index && Objects.equals(this.kernel, ((BDD)other).kernel);
    }

    public String toString() {
        return "BDD{" + this.index + "}";
    }
}

