/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.io.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.printer.FormulaStringRepresentation;

public final class FormulaWriter {
    private FormulaWriter() {
    }

    public static void write(String fileName, Formula formula, boolean splitAndMultiline) throws IOException {
        FormulaWriter.write(new File(fileName), formula, splitAndMultiline, formula.factory().stringRepresentation());
    }

    public static void write(String fileName, Formula formula, boolean splitAndMultiline, FormulaStringRepresentation formatter) throws IOException {
        FormulaWriter.write(new File(fileName), formula, splitAndMultiline, formatter);
    }

    public static void write(File file, Formula formula, boolean splitAndMultiline) throws IOException {
        FormulaWriter.write(file, formula, splitAndMultiline, formula.factory().stringRepresentation());
    }

    public static void write(File file, Formula formula, boolean splitAndMultiline, FormulaStringRepresentation formatter) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (splitAndMultiline && formula.type() == FType.AND) {
            for (Formula f : formula) {
                sb.append(formatter.toString(f)).append(System.lineSeparator());
            }
        } else {
            sb.append(formatter.toString(formula));
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            writer.append(sb);
            writer.flush();
        }
    }
}

