/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.io.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.Not;
import org.logicng.formulas.PBConstraint;

public final class FormulaDotFileWriter {
    private FormulaDotFileWriter() {
    }

    public static void write(String fileName, Formula formula, boolean alignLiterals) throws IOException {
        FormulaDotFileWriter.write(new File(fileName.endsWith(".dot") ? fileName : fileName + ".dot"), formula, alignLiterals);
    }

    public static void write(File file, Formula formula, boolean alignLiterals) throws IOException {
        StringBuilder sb = new StringBuilder(String.format("digraph G {%n", new Object[0]));
        HashMap<Formula, Integer> ids = new HashMap<Formula, Integer>();
        if (alignLiterals && !formula.literals().isEmpty()) {
            sb.append(String.format("{ rank = same;%n", new Object[0]));
        }
        int id = 0;
        for (Literal lit : formula.literals()) {
            ids.put(lit, id);
            sb.append("  id").append(id).append(" [shape=box, label=\"").append(lit.phase() ? lit.name() : "\u00ac" + lit.name()).append(String.format("\"];%n", new Object[0]));
            ++id;
        }
        if (alignLiterals && !formula.literals().isEmpty()) {
            sb.append(String.format("}%n", new Object[0]));
        }
        FormulaDotFileWriter.generateDotString(formula, sb, ids);
        sb.append(String.format("}%n", new Object[0]));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            writer.append(sb);
            writer.flush();
        }
    }

    private static void generateDotString(Formula formula, StringBuilder sb, Map<Formula, Integer> ids) {
        switch (formula.type()) {
            case FALSE: {
                sb.append(String.format("  false;%n", new Object[0]));
                break;
            }
            case TRUE: {
                sb.append(String.format("  true;%n", new Object[0]));
                break;
            }
            case LITERAL: {
                break;
            }
            case PBC: {
                int id = ids.size();
                ids.put(formula, id);
                sb.append("  id").append(id).append(" [label=\"").append(formula.toString()).append(String.format("\"];%n", new Object[0]));
                for (Literal operand : ((PBConstraint)formula).operands()) {
                    sb.append("  id").append(id).append(" -> id").append(ids.get(operand)).append(String.format(";%n", new Object[0]));
                }
                break;
            }
            case NOT: {
                FormulaDotFileWriter.generateNotDotString((Not)formula, sb, ids);
                break;
            }
            case IMPL: {
                FormulaDotFileWriter.generateBinaryDotString((BinaryOperator)formula, sb, ids, "\u21d2", true);
                break;
            }
            case EQUIV: {
                FormulaDotFileWriter.generateBinaryDotString((BinaryOperator)formula, sb, ids, "\u21d4", true);
                break;
            }
            case AND: {
                FormulaDotFileWriter.generateNaryDotString((NAryOperator)formula, sb, ids, "\u2227");
                break;
            }
            case OR: {
                FormulaDotFileWriter.generateNaryDotString((NAryOperator)formula, sb, ids, "\u2228");
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot write the formula type " + (Object)((Object)formula.type()));
            }
        }
    }

    private static void generateNotDotString(Not not, StringBuilder sb, Map<Formula, Integer> ids) {
        if (!ids.containsKey(not.operand())) {
            FormulaDotFileWriter.generateDotString(not.operand(), sb, ids);
        }
        int id = ids.size();
        ids.put(not, id);
        sb.append("  id").append(id).append(String.format(" [label=\"\u00ac\"];%n", new Object[0]));
        sb.append("  id").append(id).append(" -> id").append(ids.get(not.operand())).append(String.format(";%n", new Object[0]));
    }

    private static void generateBinaryDotString(BinaryOperator formula, StringBuilder sb, Map<Formula, Integer> ids, String op, boolean directions) {
        if (!ids.containsKey(formula.left())) {
            FormulaDotFileWriter.generateDotString(formula.left(), sb, ids);
        }
        if (!ids.containsKey(formula.right())) {
            FormulaDotFileWriter.generateDotString(formula.right(), sb, ids);
        }
        int id = ids.size();
        ids.put(formula, id);
        sb.append("  id").append(id).append(" [label=\"").append(op).append(String.format("\"];%n", new Object[0]));
        sb.append("  id").append(id).append(" -> id").append(ids.get(formula.left()));
        sb.append(directions ? String.format(" [label=\"l\"];%n", new Object[0]) : String.format(";%n", new Object[0]));
        sb.append("  id").append(id).append(" -> id").append(ids.get(formula.right()));
        sb.append(directions ? String.format(" [label=\"r\"];%n", new Object[0]) : String.format(";%n", new Object[0]));
    }

    private static void generateNaryDotString(NAryOperator formula, StringBuilder sb, Map<Formula, Integer> ids, String op) {
        for (Formula operand : formula) {
            if (ids.containsKey(operand)) continue;
            FormulaDotFileWriter.generateDotString(operand, sb, ids);
        }
        int id = ids.size();
        ids.put(formula, id);
        sb.append("  id").append(id).append(" [label=\"").append(op).append(String.format("\"];%n", new Object[0]));
        for (Formula operand : formula) {
            sb.append("  id").append(id).append(" -> id").append(ids.get(operand)).append(String.format(";%n", new Object[0]));
        }
    }
}

