/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.io.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.predicates.CNFPredicate;

public final class FormulaDimacsFileWriter {
    private FormulaDimacsFileWriter() {
    }

    public static void write(String fileName, Formula formula, boolean writeMapping) throws IOException {
        File file = new File(fileName.endsWith(".cnf") ? fileName : fileName + ".cnf");
        TreeMap<Variable, Long> var2id = new TreeMap<Variable, Long>();
        long i = 1L;
        for (Variable variable : new TreeSet<Variable>(formula.variables())) {
            var2id.put(variable, i++);
        }
        if (!formula.holds(CNFPredicate.get())) {
            throw new IllegalArgumentException("Cannot write a non-CNF formula to dimacs.  Convert to CNF first.");
        }
        ArrayList<Formula> parts = new ArrayList<Formula>();
        if (formula.type().equals((Object)FType.LITERAL)) {
            parts.add(formula);
        } else {
            for (Formula part : formula) {
                parts.add(part);
            }
        }
        StringBuilder stringBuilder = new StringBuilder("p cnf ");
        int partsSize = formula.type().equals((Object)FType.FALSE) ? 1 : parts.size();
        stringBuilder.append(var2id.size()).append(" ").append(partsSize).append(System.lineSeparator());
        for (Formula part : parts) {
            for (Literal lit : part.literals()) {
                stringBuilder.append(lit.phase() ? "" : "-").append(var2id.get(lit.variable())).append(" ");
            }
            stringBuilder.append(String.format(" 0%n", new Object[0]));
        }
        if (formula.type().equals((Object)FType.FALSE)) {
            stringBuilder.append(String.format("0%n", new Object[0]));
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            writer.append(stringBuilder);
            writer.flush();
        }
        if (writeMapping) {
            String mappingFileName = (fileName.endsWith(".cnf") ? fileName.substring(0, fileName.length() - 4) : fileName) + ".map";
            FormulaDimacsFileWriter.writeMapping(new File(mappingFileName), var2id);
        }
    }

    private static void writeMapping(File mappingFile, SortedMap<Variable, Long> var2id) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Variable, Long> entry : var2id.entrySet()) {
            sb.append(entry.getKey()).append(";").append(entry.getValue()).append(System.lineSeparator());
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mappingFile), StandardCharsets.UTF_8));){
            writer.append(sb);
            writer.flush();
        }
    }
}

