/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.io.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.io.parsers.FormulaParser;
import org.logicng.io.parsers.ParserException;
import org.logicng.io.parsers.PropositionalParser;
import org.logicng.io.parsers.PseudoBooleanParser;

public final class FormulaReader {
    private FormulaReader() {
    }

    public static Formula readPropositionalFormula(String fileName, FormulaFactory f) throws IOException, ParserException {
        return FormulaReader.read(new File(fileName), new PropositionalParser(f));
    }

    public static Formula readPropositionalFormula(File file, FormulaFactory f) throws IOException, ParserException {
        return FormulaReader.read(file, new PropositionalParser(f));
    }

    public static Formula readPseudoBooleanFormula(String fileName, FormulaFactory f) throws IOException, ParserException {
        return FormulaReader.read(new File(fileName), new PseudoBooleanParser(f));
    }

    public static Formula readPseudoBooleanFormula(File file, FormulaFactory f) throws IOException, ParserException {
        return FormulaReader.read(file, new PseudoBooleanParser(f));
    }

    private static Formula read(File file, FormulaParser parser) throws IOException, ParserException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            LinkedHashSet<Formula> ops = new LinkedHashSet<Formula>();
            while (br.ready()) {
                ops.add(parser.parse(br.readLine()));
            }
            Formula formula = parser.factory().and(ops);
            return formula;
        }
    }
}

