/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.io.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;

public final class DimacsReader {
    private DimacsReader() {
    }

    public static List<Formula> readCNF(File file, FormulaFactory f) throws IOException {
        return DimacsReader.readCNF(file, f, "v");
    }

    public static List<Formula> readCNF(File file, FormulaFactory f, String prefix) throws IOException {
        ArrayList<Formula> result = new ArrayList<Formula>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            while (br.ready()) {
                String line = br.readLine();
                if (line.startsWith("c") || line.startsWith("p") || line.trim().isEmpty()) continue;
                String[] split = line.split("\\s+");
                if (!"0".equals(split[split.length - 1].trim())) {
                    throw new IllegalArgumentException("Line '" + line + "' did not end with 0.");
                }
                LinkedHashSet<Literal> vars = new LinkedHashSet<Literal>(split.length - 1);
                for (int i = 0; i < split.length - 1; ++i) {
                    String lit = split[i].trim();
                    if (lit.isEmpty()) continue;
                    if (lit.startsWith("-")) {
                        vars.add(f.literal(prefix + split[i].trim().substring(1), false));
                        continue;
                    }
                    vars.add(f.variable(prefix + split[i].trim()));
                }
                result.add(f.or(vars));
            }
        }
        return result;
    }

    public static List<Formula> readCNF(String fileName, FormulaFactory f) throws IOException {
        return DimacsReader.readCNF(new File(fileName), f, "v");
    }

    public static List<Formula> readCNF(String fileName, FormulaFactory f, String prefix) throws IOException {
        return DimacsReader.readCNF(new File(fileName), f, prefix);
    }
}

