/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.io.parsers;

import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.io.parsers.LexerException;
import org.logicng.io.parsers.ParserException;
import org.logicng.io.parsers.ParserWithFormula;

public abstract class FormulaParser {
    private final FormulaFactory f;
    private Lexer lexer;
    private ParserWithFormula parser;

    protected FormulaParser(FormulaFactory f) {
        this.f = f;
    }

    protected void setLexerAndParser(Lexer lexer, ParserWithFormula parser) {
        this.lexer = lexer;
        this.parser = parser;
        this.parser.setFormulaFactory(this.f);
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
        this.parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
    }

    public Formula parse(InputStream inputStream) throws ParserException {
        if (inputStream == null) {
            return this.f.verum();
        }
        try {
            CharStream input = CharStreams.fromStream((InputStream)inputStream);
            this.lexer.setInputStream((IntStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)this.lexer);
            this.parser.setInputStream((IntStream)tokens);
            return this.parser.getParsedFormula();
        }
        catch (IOException e) {
            throw new ParserException("IO exception when parsing the formula", e);
        }
        catch (ParseCancellationException e) {
            throw new ParserException("Parse cancellation exception when parsing the formula", (Exception)((Object)e));
        }
        catch (LexerException e) {
            throw new ParserException("Lexer exception when parsing the formula.", e);
        }
    }

    public Formula parse(String in) throws ParserException {
        if (in == null || in.isEmpty()) {
            return this.f.verum();
        }
        try {
            CodePointCharStream input = CharStreams.fromString((String)in);
            this.lexer.setInputStream((IntStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)this.lexer);
            this.parser.setInputStream((IntStream)tokens);
            return this.parser.getParsedFormula();
        }
        catch (ParseCancellationException e) {
            throw new ParserException("Parse cancellation exception when parsing the formula", (Exception)((Object)e));
        }
        catch (LexerException e) {
            throw new ParserException("Lexer exception when parsing the formula.", e);
        }
    }

    public FormulaFactory factory() {
        return this.f;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

