/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.handlers;

import org.logicng.datastructures.Assignment;
import org.logicng.handlers.MaxSATHandler;
import org.logicng.handlers.SATHandler;
import org.logicng.handlers.TimeoutHandler;
import org.logicng.handlers.TimeoutSATHandler;

public final class TimeoutMaxSATHandler
extends TimeoutHandler
implements MaxSATHandler {
    private final TimeoutSATHandler satHandler;
    private int currentLb;
    private int currentUb;

    public TimeoutMaxSATHandler(long timeout) {
        super(timeout);
        this.satHandler = new TimeoutSATHandler(timeout);
        this.currentLb = -1;
        this.currentUb = -1;
    }

    @Override
    public void started() {
        super.started();
        this.satHandler.started();
        this.currentLb = -1;
        this.currentUb = -1;
    }

    @Override
    public SATHandler satHandler() {
        return this.satHandler;
    }

    @Override
    public boolean foundLowerBound(int lowerBound, Assignment model) {
        this.currentLb = lowerBound;
        return this.timeLimitExceeded();
    }

    @Override
    public boolean foundUpperBound(int upperBound, Assignment model) {
        this.currentUb = upperBound;
        return this.timeLimitExceeded();
    }

    @Override
    public boolean satSolverFinished() {
        this.aborted = this.satHandler.aborted();
        return !this.aborted;
    }

    @Override
    public void finishedSolving() {
    }

    @Override
    public int lowerBoundApproximation() {
        return this.currentLb;
    }

    @Override
    public int upperBoundApproximation() {
        return this.currentUb;
    }
}

