/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import org.logicng.graphs.datastructures.Graph;
import org.logicng.graphs.datastructures.Node;

public final class GraphDotFileWriter {
    private GraphDotFileWriter() {
    }

    public static <T> void write(String fileName, Graph<T> graph) throws IOException {
        GraphDotFileWriter.write(new File(fileName.endsWith(".dot") ? fileName : fileName + ".dot"), graph);
    }

    public static <T> void write(File file, Graph<T> graph) throws IOException {
        StringBuilder sb = new StringBuilder(String.format("strict graph {%n", new Object[0]));
        LinkedHashSet<Node<T>> doneNodes = new LinkedHashSet<Node<T>>();
        for (Node<T> d : graph.nodes()) {
            for (Node<T> n : d.neighbours()) {
                if (doneNodes.contains(n)) continue;
                sb.append("  ").append(d.content()).append(" -- ").append(n.content()).append(System.lineSeparator());
            }
            doneNodes.add(d);
        }
        for (Node<T> d : graph.nodes()) {
            if (!d.neighbours().isEmpty()) continue;
            sb.append("  ").append(d.content()).append(System.lineSeparator());
        }
        sb.append("}");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            writer.append(sb);
            writer.flush();
        }
    }
}

