/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.logicng.graphs.datastructures.Graph;
import org.logicng.graphs.datastructures.Node;
import org.logicng.util.Pair;

public final class GraphDimacsFileWriter {
    private GraphDimacsFileWriter() {
    }

    public static <T> void write(String fileName, Graph<T> g, boolean writeMapping) throws IOException {
        File file = new File(fileName.endsWith(".col") ? fileName : fileName + ".col");
        LinkedHashMap<Node<T>, Long> node2id = new LinkedHashMap<Node<T>, Long>();
        long i = 1L;
        for (Node<T> node : g.nodes()) {
            node2id.put(node, i++);
        }
        StringBuilder sb = new StringBuilder("p edge ");
        LinkedHashSet<Pair<Node<T>, Node<T>>> edges = new LinkedHashSet<Pair<Node<T>, Node<T>>>();
        LinkedHashSet<Node<T>> doneNodes = new LinkedHashSet<Node<T>>();
        for (Node<T> node : g.nodes()) {
            for (Node<T> n : node.neighbours()) {
                if (doneNodes.contains(n)) continue;
                edges.add(new Pair<Node<T>, Node<T>>(node, n));
            }
            doneNodes.add(node);
        }
        sb.append(node2id.size()).append(" ").append(edges.size()).append(System.lineSeparator());
        for (Pair pair : edges) {
            sb.append("e ").append(node2id.get(pair.first())).append(" ").append(node2id.get(pair.second())).append(System.lineSeparator());
        }
        Throwable throwable = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            writer.append(sb);
            writer.flush();
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (writeMapping) {
            String mappingFileName = (fileName.endsWith(".col") ? fileName.substring(0, fileName.length() - 4) : fileName) + ".map";
            GraphDimacsFileWriter.writeMapping(new File(mappingFileName), node2id);
        }
    }

    private static <T> void writeMapping(File mappingFile, Map<Node<T>, Long> node2id) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Node<T>, Long> entry : node2id.entrySet()) {
            sb.append(entry.getKey().content()).append(";").append(entry.getValue()).append(System.lineSeparator());
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mappingFile), StandardCharsets.UTF_8));){
            writer.append(sb);
            writer.flush();
        }
    }
}

