/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.generators;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.graphs.datastructures.Hypergraph;
import org.logicng.graphs.datastructures.HypergraphNode;
import org.logicng.predicates.CNFPredicate;

public final class HypergraphGenerator {
    public static Hypergraph<Variable> fromCNF(Formula ... cnf) {
        return HypergraphGenerator.fromCNF(Arrays.asList(cnf));
    }

    public static Hypergraph<Variable> fromCNF(List<Formula> cnf) {
        Hypergraph<Variable> hypergraph = new Hypergraph<Variable>();
        HashMap<Variable, HypergraphNode<Variable>> nodes = new HashMap<Variable, HypergraphNode<Variable>>();
        for (Formula clause : cnf) {
            switch (clause.type()) {
                case PBC: 
                case EQUIV: 
                case IMPL: 
                case NOT: 
                case AND: {
                    throw new IllegalStateException("Unexpected element in clause: " + clause);
                }
                case LITERAL: 
                case OR: {
                    HypergraphGenerator.addClause(clause, hypergraph, nodes);
                }
            }
        }
        return hypergraph;
    }

    public static Hypergraph<Variable> fromCNF(Formula cnf) {
        if (!cnf.holds(CNFPredicate.get())) {
            throw new IllegalArgumentException("Cannot generate a hypergraph from a non-cnf formula");
        }
        Hypergraph<Variable> hypergraph = new Hypergraph<Variable>();
        HashMap<Variable, HypergraphNode<Variable>> nodes = new HashMap<Variable, HypergraphNode<Variable>>();
        switch (cnf.type()) {
            case PBC: 
            case EQUIV: 
            case IMPL: 
            case NOT: {
                throw new IllegalStateException("Unexpected element in CNF: " + cnf);
            }
            case LITERAL: 
            case OR: {
                HypergraphGenerator.addClause(cnf, hypergraph, nodes);
                break;
            }
            case AND: {
                for (Formula clause : cnf) {
                    HypergraphGenerator.addClause(clause, hypergraph, nodes);
                }
                break;
            }
        }
        return hypergraph;
    }

    private static void addClause(Formula formula, Hypergraph<Variable> hypergraph, Map<Variable, HypergraphNode<Variable>> nodes) {
        assert (formula.type() == FType.LITERAL || formula.type() == FType.OR);
        SortedSet<Variable> variables = formula.variables();
        LinkedHashSet clause = new LinkedHashSet();
        for (Variable variable : variables) {
            HypergraphNode<Variable> node = nodes.get(variable);
            if (node == null) {
                node = new HypergraphNode<Variable>(hypergraph, variable);
                nodes.put(variable, node);
            }
            clause.add(node);
        }
        hypergraph.addEdge(clause);
    }
}

