/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.generators;

import java.util.Collection;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.graphs.datastructures.Graph;

public final class ConstraintGraphGenerator {
    private ConstraintGraphGenerator() {
    }

    public static Graph<Variable> generateFromCnf(Formula formula) {
        Graph<Variable> constraintGraph = new Graph<Variable>();
        ConstraintGraphGenerator.addToGraph(formula, constraintGraph);
        return constraintGraph;
    }

    public static Graph<Variable> generateFromCnf(Collection<Formula> formulas) {
        Graph<Variable> constraintGraph = new Graph<Variable>();
        for (Formula clause : formulas) {
            ConstraintGraphGenerator.addToGraph(clause, constraintGraph);
        }
        return constraintGraph;
    }

    public static Graph<Variable> generateFromFormulas(Collection<Formula> formulas) {
        Graph<Variable> constraintGraph = new Graph<Variable>();
        for (Formula formula : formulas) {
            ConstraintGraphGenerator.addClause(formula, constraintGraph);
        }
        return constraintGraph;
    }

    private static void addToGraph(Formula formula, Graph<Variable> constraintGraph) {
        switch (formula.type()) {
            case FALSE: 
            case TRUE: {
                break;
            }
            case LITERAL: 
            case OR: 
            case PBC: {
                ConstraintGraphGenerator.addClause(formula, constraintGraph);
                break;
            }
            case AND: {
                for (Formula clause : formula) {
                    ConstraintGraphGenerator.addClause(clause, constraintGraph);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Can only generate a constraint graph from a CNF");
            }
        }
    }

    private static void addClause(Formula clause, Graph<Variable> graph) {
        Variable[] variables = clause.variables().toArray(new Variable[0]);
        if (variables.length == 1) {
            graph.node(variables[0]);
        }
        for (int i = 0; i < variables.length; ++i) {
            for (int j = i + 1; j < variables.length; ++j) {
                graph.connect(graph.node(variables[i]), graph.node(variables[j]));
            }
        }
    }
}

