/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.datastructures;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.logicng.graphs.datastructures.Graph;

public final class Node<T> {
    private final Graph<T> graph;
    private final T content;
    private final Set<Node<T>> neighbours;

    Node(T content, Graph<T> graph) {
        this.content = content;
        this.graph = graph;
        this.neighbours = new LinkedHashSet<Node<T>>();
    }

    void connectTo(Node<T> o) {
        if (!this.graph.equals(o.graph)) {
            throw new IllegalArgumentException("Cannot connect to nodes of two different graphs.");
        }
        if (this.equals(o)) {
            return;
        }
        this.neighbours.add(o);
    }

    void disconnectFrom(Node<T> o) {
        this.neighbours.remove(o);
    }

    public T content() {
        return this.content;
    }

    public Set<Node<T>> neighbours() {
        return new LinkedHashSet<Node<T>>(this.neighbours);
    }

    public Graph<T> graph() {
        return this.graph;
    }

    public int hashCode() {
        int result = this.graph.hashCode();
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.graph.equals(node.graph) && Objects.equals(this.content, node.content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node{content=").append(this.content).append(", neighbours:");
        for (Node<T> neighbour : this.neighbours) {
            sb.append(neighbour.content()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }
}

