/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.datastructures;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.logicng.graphs.datastructures.Hypergraph;
import org.logicng.graphs.datastructures.HypergraphEdge;

public final class HypergraphNode<T> {
    private final Hypergraph<T> graph;
    private final T content;
    private final LinkedHashSet<HypergraphEdge<T>> edges;

    public HypergraphNode(Hypergraph<T> graph, T content) {
        this.graph = graph;
        this.content = content;
        this.edges = new LinkedHashSet();
        this.graph.addNode(this);
    }

    public Hypergraph<T> graph() {
        return this.graph;
    }

    public T content() {
        return this.content;
    }

    public Set<HypergraphEdge<T>> edges() {
        return this.edges;
    }

    public void addEdge(HypergraphEdge<T> edge) {
        this.edges.add(edge);
    }

    public double computeTentativeNewLocation(Map<HypergraphNode<T>, Integer> nodeOrdering) {
        double newLocation = 0.0;
        for (HypergraphEdge hypergraphEdge : this.edges) {
            newLocation += hypergraphEdge.centerOfGravity(nodeOrdering);
        }
        return newLocation / (double)this.edges.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HypergraphNode that = (HypergraphNode)o;
        return Objects.equals(this.graph, that.graph) && Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.graph, this.content);
    }

    public String toString() {
        return "HypergraphNode{content=" + this.content + '}';
    }
}

