/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.datastructures;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.logicng.graphs.datastructures.HypergraphNode;

public final class HypergraphEdge<T> {
    private final LinkedHashSet<HypergraphNode<T>> nodes;

    public HypergraphEdge(Collection<HypergraphNode<T>> nodes) {
        this.nodes = new LinkedHashSet<HypergraphNode<T>>(nodes);
        for (HypergraphNode<T> node : nodes) {
            node.addEdge(this);
        }
    }

    @SafeVarargs
    public HypergraphEdge(HypergraphNode<T> ... nodes) {
        this(Arrays.asList(nodes));
    }

    public Set<HypergraphNode<T>> nodes() {
        return this.nodes;
    }

    public double centerOfGravity(Map<HypergraphNode<T>, Integer> nodeOrdering) {
        int cog = 0;
        for (HypergraphNode hypergraphNode : this.nodes) {
            Integer level = nodeOrdering.get(hypergraphNode);
            if (level == null) {
                throw new IllegalStateException("Could not find node " + hypergraphNode + " in the node ordering.");
            }
            cog += level.intValue();
        }
        return (double)cog / (double)this.nodes.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HypergraphEdge that = (HypergraphEdge)o;
        return Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }

    public String toString() {
        return "HypergraphEdge{nodes=" + this.nodes + '}';
    }
}

