/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.datastructures;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.logicng.graphs.datastructures.HypergraphEdge;
import org.logicng.graphs.datastructures.HypergraphNode;

public final class Hypergraph<T> {
    private final LinkedHashSet<HypergraphNode<T>> nodes = new LinkedHashSet();
    private final LinkedHashSet<HypergraphEdge<T>> edges = new LinkedHashSet();

    public Set<HypergraphNode<T>> nodes() {
        return this.nodes;
    }

    public Set<HypergraphEdge<T>> edges() {
        return this.edges;
    }

    void addNode(HypergraphNode<T> node) {
        this.nodes.add(node);
    }

    public void addEdge(HypergraphEdge<T> edge) {
        this.edges.add(edge);
    }

    public void addEdge(Collection<HypergraphNode<T>> nodes) {
        HypergraphEdge<T> edge = new HypergraphEdge<T>(nodes);
        this.nodes.addAll(nodes);
        this.edges.add(edge);
    }

    @SafeVarargs
    public final void addEdge(HypergraphNode<T> ... nodes) {
        this.addEdge(Arrays.asList(nodes));
    }

    public void addEdges(Collection<HypergraphEdge<T>> edges) {
        this.edges.addAll(edges);
    }

    public String toString() {
        return "Hypergraph{nodes=" + this.nodes + ", edges=" + this.edges + '}';
    }
}

