/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.datastructures;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.logicng.graphs.datastructures.Node;

public final class Graph<T> {
    private final String name;
    private final Map<T, Node<T>> nodes = new LinkedHashMap<T, Node<T>>();

    public Graph() {
        this("");
    }

    public Graph(String name) {
        this.name = name;
    }

    public Node<T> node(T content) {
        Node<T> search = this.nodes.get(content);
        if (search != null) {
            return search;
        }
        Node<T> n = new Node<T>(content, this);
        this.nodes.put(content, n);
        return n;
    }

    public Set<Node<T>> nodes() {
        return new LinkedHashSet<Node<T>>(this.nodes.values());
    }

    public void connect(Node<T> o, Node<T> t) {
        if (!o.equals(t)) {
            o.connectTo(t);
            t.connectTo(o);
        }
    }

    public void disconnect(Node<T> o, Node<T> t) {
        if (!o.equals(t)) {
            o.disconnectFrom(t);
            t.disconnectFrom(o);
        }
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "Graph{name='" + this.name + '\'' + ", nodes=" + this.nodes.values() + '}';
    }
}

