/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.graphs.datastructures.Graph;
import org.logicng.graphs.datastructures.Node;

public final class ConnectedComponentsComputation {
    private ConnectedComponentsComputation() {
    }

    public static <T> Set<Set<Node<T>>> compute(Graph<T> graph) {
        LinkedHashSet<Set<Node<T>>> connectedComponents = new LinkedHashSet<Set<Node<T>>>();
        LinkedHashSet<Node<T>> unmarkedNodes = new LinkedHashSet<Node<T>>(graph.nodes());
        while (!unmarkedNodes.isEmpty()) {
            LinkedHashSet<Node<T>> connectedComp = new LinkedHashSet<Node<T>>();
            ConnectedComponentsComputation.deepFirstSearch((Node)unmarkedNodes.iterator().next(), connectedComp, unmarkedNodes);
            connectedComponents.add(connectedComp);
        }
        return connectedComponents;
    }

    public static List<List<Formula>> splitFormulasByComponent(Collection<Formula> formulas, Set<Set<Node<Variable>>> components) {
        LinkedHashMap<Set, List> map = new LinkedHashMap<Set, List>();
        TreeMap<Variable, Set<Node<Variable>>> varMap = new TreeMap<Variable, Set<Node<Variable>>>();
        for (Set<Node<Variable>> component : components) {
            for (Node<Variable> variableNode : component) {
                varMap.put(variableNode.content(), component);
            }
        }
        for (Formula formula : formulas) {
            SortedSet<Variable> variables = formula.variables();
            if (variables.isEmpty()) {
                map.computeIfAbsent(Collections.emptySet(), l -> new ArrayList()).add(formula);
                continue;
            }
            Set component = (Set)varMap.get(variables.first());
            if (component == null) {
                throw new IllegalArgumentException("Could not find a component for the variable " + variables.first());
            }
            map.computeIfAbsent(component, l -> new ArrayList()).add(formula);
        }
        return Collections.unmodifiableList(new ArrayList(map.values()));
    }

    private static <T> void deepFirstSearch(Node<T> v, Set<Node<T>> component, Set<Node<T>> unmarkedNodes) {
        component.add(v);
        unmarkedNodes.remove(v);
        for (Node<T> neigh : v.neighbours()) {
            if (!unmarkedNodes.contains(neigh)) continue;
            ConnectedComponentsComputation.deepFirstSearch(neigh, component, unmarkedNodes);
        }
    }
}

