/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.graphs.algorithms;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.graphs.datastructures.Graph;
import org.logicng.graphs.datastructures.Node;

public final class BronKerbosch<T extends Comparable<T>> {
    private final Graph<T> g;
    private final Comparator<Node<T>> nodeComparator;
    private final Set<SortedSet<Node<T>>> cliques;

    public BronKerbosch(Graph<T> g) {
        this.g = g;
        this.nodeComparator = Comparator.comparing(Node::content);
        this.cliques = new LinkedHashSet<SortedSet<Node<T>>>();
    }

    public Set<SortedSet<Node<T>>> compute() {
        this.cliques.clear();
        TreeSet<Node<T>> p = new TreeSet<Node<T>>(this.nodeComparator);
        p.addAll(this.g.nodes());
        this.bk(new TreeSet<Node<T>>(this.nodeComparator), p, new TreeSet<Node<T>>(this.nodeComparator));
        return this.cliques;
    }

    private void bk(SortedSet<Node<T>> r, SortedSet<Node<T>> p, SortedSet<Node<T>> x) {
        if (p.isEmpty() && x.isEmpty()) {
            this.cliques.add(r);
            return;
        }
        TreeSet<Node<T>> pvx = new TreeSet<Node<T>>(new NodeNeighbourComparator());
        pvx.addAll(p);
        pvx.addAll(x);
        Node u = (Node)pvx.last();
        TreeSet<Node<T>> pwnu = new TreeSet<Node<T>>(this.nodeComparator);
        pwnu.addAll(p);
        pwnu.removeAll(u.neighbours());
        for (Node node : pwnu) {
            TreeSet<Node<T>> nr = new TreeSet<Node<T>>(this.nodeComparator);
            nr.addAll(r);
            nr.add(node);
            TreeSet<Node<T>> np = new TreeSet<Node<T>>(this.nodeComparator);
            TreeSet<Node<T>> nx = new TreeSet<Node<T>>(this.nodeComparator);
            for (Node neigh : node.neighbours()) {
                if (p.contains(neigh)) {
                    np.add(neigh);
                }
                if (!x.contains(neigh)) continue;
                nx.add(neigh);
            }
            this.bk(nr, np, nx);
            p.remove(node);
            x.add(node);
        }
    }

    public List<List<T>> getCliquesAsTLists() {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (Set set : this.cliques) {
            ArrayList curList = new ArrayList();
            for (Node node : set) {
                curList.add(node.content());
            }
            result.add(curList);
        }
        return result;
    }

    private class NodeNeighbourComparator
    implements Comparator<Node<T>> {
        private NodeNeighbourComparator() {
        }

        @Override
        public int compare(Node<T> n1, Node<T> n2) {
            if (n1.neighbours().size() > n2.neighbours().size()) {
                return 1;
            }
            if (n1.neighbours().size() < n2.neighbours().size()) {
                return -1;
            }
            return BronKerbosch.this.nodeComparator.compare(n1, n2);
        }
    }
}

