/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFunction;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.formulas.cache.FunctionCacheEntry;

public final class VariableProfileFunction
implements FormulaFunction<Map<Variable, Integer>> {
    private static Map<Variable, Integer> nonCachingVariableProfile(Formula formula) {
        TreeMap<Variable, Integer> map = new TreeMap<Variable, Integer>();
        VariableProfileFunction.nonCachingRecursion(formula, map);
        return map;
    }

    private static void nonCachingRecursion(Formula formula, Map<Variable, Integer> map) {
        if (formula.type() == FType.LITERAL) {
            Literal lit = (Literal)formula;
            map.merge(lit.variable(), 1, Integer::sum);
        } else if (formula.type() == FType.PBC) {
            for (Literal l : formula.literals()) {
                VariableProfileFunction.nonCachingRecursion(l.variable(), map);
            }
        } else {
            for (Formula op : formula) {
                VariableProfileFunction.nonCachingRecursion(op, map);
            }
        }
    }

    private static Map<Variable, Integer> cachingVariableProfile(Formula formula) {
        Object cached = formula.functionCacheEntry(FunctionCacheEntry.VARPROFILE);
        if (cached != null) {
            return (Map)cached;
        }
        HashMap<Variable, Integer> result = new HashMap<Variable, Integer>();
        if (formula.type() == FType.LITERAL) {
            result.put(((Literal)formula).variable(), 1);
        } else if (formula.type() == FType.PBC) {
            for (Literal l : formula.literals()) {
                result.put(l.variable(), 1);
            }
        } else {
            for (Formula op : formula) {
                Map<Variable, Integer> temp = VariableProfileFunction.cachingVariableProfile(op);
                for (Map.Entry<Variable, Integer> entry : temp.entrySet()) {
                    result.merge(entry.getKey(), entry.getValue(), Integer::sum);
                }
            }
        }
        formula.setFunctionCacheEntry(FunctionCacheEntry.VARPROFILE, result);
        return result;
    }

    @Override
    public Map<Variable, Integer> apply(Formula formula, boolean cache) {
        return cache ? VariableProfileFunction.cachingVariableProfile(formula) : VariableProfileFunction.nonCachingVariableProfile(formula);
    }
}

