/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.functions;

import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFunction;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SATSolver;
import org.logicng.solvers.functions.OptimizationFunction;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.transformations.LiteralSubstitution;

public final class MinimumPrimeImplicantFunction
implements FormulaFunction<SortedSet<Literal>> {
    private static final String POS = "_POS";
    private static final String NEG = "_NEG";
    private static final MinimumPrimeImplicantFunction INSTANCE = new MinimumPrimeImplicantFunction();

    private MinimumPrimeImplicantFunction() {
    }

    public static MinimumPrimeImplicantFunction get() {
        return INSTANCE;
    }

    @Override
    public SortedSet<Literal> apply(Formula formula, boolean cache) {
        Formula nnf = formula.nnf();
        HashMap<Object, Literal> newVar2oldLit = new HashMap<Object, Literal>();
        LiteralSubstitution substitution = new LiteralSubstitution();
        for (Literal literal : nnf.literals()) {
            Variable newVar = formula.factory().variable(literal.name() + (literal.phase() ? POS : NEG));
            newVar2oldLit.put(newVar, literal);
            substitution.addSubstitution(literal, newVar);
        }
        Formula substitued = nnf.transform(substitution);
        MiniSat solver = MiniSat.miniSat(formula.factory(), MiniSatConfig.builder().cnfMethod(MiniSatConfig.CNFMethod.PG_ON_SOLVER).build());
        solver.add(substitued);
        for (Literal literal : newVar2oldLit.values()) {
            if (!literal.phase() || !newVar2oldLit.containsValue(literal.negate())) continue;
            solver.add(formula.factory().amo(formula.factory().variable(literal.name() + POS), formula.factory().variable(literal.name() + NEG)));
        }
        if (solver.sat() != Tristate.TRUE) {
            return null;
        }
        Assignment minimumModel = ((SATSolver)solver).execute(OptimizationFunction.minimize(newVar2oldLit.keySet()));
        TreeSet<Literal> primeImplicant = new TreeSet<Literal>();
        for (Variable variable : minimumModel.positiveVariables()) {
            Literal literal = (Literal)newVar2oldLit.get(variable);
            if (literal == null) continue;
            primeImplicant.add(literal);
        }
        return primeImplicant;
    }
}

