/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFunction;
import org.logicng.formulas.Literal;
import org.logicng.formulas.cache.FunctionCacheEntry;

public final class LiteralProfileFunction
implements FormulaFunction<Map<Literal, Integer>> {
    private static Map<Literal, Integer> nonCachingLiteralProfile(Formula formula) {
        TreeMap<Literal, Integer> map = new TreeMap<Literal, Integer>();
        LiteralProfileFunction.nonCachingRecursion(formula, map);
        return map;
    }

    private static void nonCachingRecursion(Formula formula, Map<Literal, Integer> map) {
        if (formula.type() == FType.LITERAL) {
            Literal lit = (Literal)formula;
            map.merge(lit, 1, Integer::sum);
        } else if (formula.type() == FType.PBC) {
            for (Literal l : formula.literals()) {
                LiteralProfileFunction.nonCachingRecursion(l, map);
            }
        } else {
            for (Formula op : formula) {
                LiteralProfileFunction.nonCachingRecursion(op, map);
            }
        }
    }

    private static Map<Literal, Integer> cachingLiteralProfile(Formula formula) {
        Object cached = formula.functionCacheEntry(FunctionCacheEntry.LITPROFILE);
        if (cached != null) {
            return (Map)cached;
        }
        HashMap<Literal, Integer> result = new HashMap<Literal, Integer>();
        if (formula.type() == FType.LITERAL) {
            result.put((Literal)formula, 1);
        } else if (formula.type() == FType.PBC) {
            for (Literal l : formula.literals()) {
                result.put(l, 1);
            }
        } else {
            for (Formula op : formula) {
                Map<Literal, Integer> temp = LiteralProfileFunction.cachingLiteralProfile(op);
                for (Map.Entry<Literal, Integer> entry : temp.entrySet()) {
                    result.merge(entry.getKey(), entry.getValue(), Integer::sum);
                }
            }
        }
        formula.setFunctionCacheEntry(FunctionCacheEntry.LITPROFILE, result);
        return result;
    }

    @Override
    public Map<Literal, Integer> apply(Formula formula, boolean cache) {
        return cache ? LiteralProfileFunction.cachingLiteralProfile(formula) : LiteralProfileFunction.nonCachingLiteralProfile(formula);
    }
}

