/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.functions;

import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFunction;
import org.logicng.formulas.cache.FunctionCacheEntry;

public final class FormulaDepthFunction
implements FormulaFunction<Integer> {
    @Override
    public Integer apply(Formula formula, boolean cache) {
        int result;
        Object cached = formula.functionCacheEntry(FunctionCacheEntry.DEPTH);
        if (cached != null) {
            return (Integer)cached;
        }
        if (formula.isAtomicFormula()) {
            result = 0;
        } else {
            int maxDepth = 0;
            for (Formula op : formula) {
                maxDepth = Math.max(maxDepth, this.apply(op, cache));
            }
            result = maxDepth + 1;
        }
        if (cache) {
            formula.setFunctionCacheEntry(FunctionCacheEntry.DEPTH, result);
        }
        return result;
    }
}

