/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas.printer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logicng.formulas.CType;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.printer.FormulaStringRepresentation;

public final class UTF8StringRepresentation
extends FormulaStringRepresentation {
    private static final Pattern pattern = Pattern.compile("(.*?)(\\d*)");

    private static String utf8Name(String name) {
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            return name;
        }
        if (matcher.group(2).isEmpty()) {
            return matcher.group(1);
        }
        return matcher.group(1) + UTF8StringRepresentation.getSubscript(matcher.group(2));
    }

    private static String getSubscript(String number) {
        StringBuilder sb = new StringBuilder();
        block12: for (char c : number.toCharArray()) {
            switch (c) {
                case '0': {
                    sb.append("\u2080");
                    continue block12;
                }
                case '1': {
                    sb.append("\u2081");
                    continue block12;
                }
                case '2': {
                    sb.append("\u2082");
                    continue block12;
                }
                case '3': {
                    sb.append("\u2083");
                    continue block12;
                }
                case '4': {
                    sb.append("\u2084");
                    continue block12;
                }
                case '5': {
                    sb.append("\u2085");
                    continue block12;
                }
                case '6': {
                    sb.append("\u2086");
                    continue block12;
                }
                case '7': {
                    sb.append("\u2087");
                    continue block12;
                }
                case '8': {
                    sb.append("\u2088");
                    continue block12;
                }
                case '9': {
                    sb.append("\u2089");
                    continue block12;
                }
            }
        }
        return sb.toString();
    }

    @Override
    protected String toInnerString(Formula formula) {
        if (formula.type() == FType.LITERAL) {
            Literal lit = (Literal)formula;
            return lit.phase() ? UTF8StringRepresentation.utf8Name(lit.name()) : this.negation() + UTF8StringRepresentation.utf8Name(lit.name());
        }
        return super.toInnerString(formula);
    }

    @Override
    protected String falsum() {
        return "\u22a5";
    }

    @Override
    protected String verum() {
        return "\u22a4";
    }

    @Override
    protected String negation() {
        return "\u00ac";
    }

    @Override
    protected String implication() {
        return " \u21d2 ";
    }

    @Override
    protected String equivalence() {
        return " \u21d4 ";
    }

    @Override
    protected String and() {
        return " \u2227 ";
    }

    @Override
    protected String or() {
        return " \u2228 ";
    }

    @Override
    protected String pbComparator(CType comparator) {
        switch (comparator) {
            case EQ: {
                return " = ";
            }
            case LE: {
                return " \u2264 ";
            }
            case LT: {
                return " < ";
            }
            case GE: {
                return " \u2265 ";
            }
            case GT: {
                return " > ";
            }
        }
        throw new IllegalArgumentException("Unknown pseudo-Boolean comparison: " + (Object)((Object)comparator));
    }

    @Override
    protected String pbMul() {
        return "";
    }

    @Override
    protected String pbAdd() {
        return " + ";
    }

    @Override
    protected String lbr() {
        return "(";
    }

    @Override
    protected String rbr() {
        return ")";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

