/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas.printer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.Equivalence;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.Not;
import org.logicng.formulas.PBConstraint;
import org.logicng.formulas.Variable;
import org.logicng.formulas.printer.DefaultStringRepresentation;

public final class SortedStringRepresentation
extends DefaultStringRepresentation {
    private final List<Variable> varOrder;
    private final FormulaComparator comparator;

    public SortedStringRepresentation(List<Variable> varOrder) {
        this.varOrder = varOrder;
        this.comparator = new FormulaComparator(varOrder);
    }

    @Override
    public String toInnerString(Formula formula) {
        switch (formula.type()) {
            case FALSE: {
                return this.falsum();
            }
            case TRUE: {
                return this.verum();
            }
            case LITERAL: {
                Literal lit = (Literal)formula;
                return lit.phase() ? lit.name() : this.negation() + lit.name();
            }
            case NOT: {
                Not not = (Not)formula;
                return this.negation() + this.bracket(not.operand());
            }
            case IMPL: {
                return this.binaryOperator((BinaryOperator)formula, this.implication());
            }
            case EQUIV: {
                return this.sortedEquivalence((Equivalence)formula);
            }
            case AND: 
            case OR: {
                NAryOperator nary = (NAryOperator)formula;
                String op = formula.type() == FType.AND ? this.and() : this.or();
                return this.naryOperator(nary, String.format("%s", op));
            }
            case PBC: {
                PBConstraint pbc = (PBConstraint)formula;
                return String.format("%s%s%d", this.pbLhs(pbc.operands(), pbc.coefficients()), this.pbComparator(pbc.comparator()), pbc.rhs());
            }
        }
        throw new IllegalArgumentException("Cannot print the unknown formula type " + (Object)((Object)formula.type()));
    }

    @Override
    protected String naryOperator(NAryOperator operator, String opString) {
        ArrayList<Formula> operands = new ArrayList<Formula>();
        for (Formula op : operator) {
            operands.add(op);
        }
        int size = operator.numberOfOperands();
        operands.sort(this.comparator);
        StringBuilder sb = new StringBuilder();
        int count = 0;
        Formula last = null;
        for (Formula op : operands) {
            if (++count == size) {
                last = op;
                continue;
            }
            sb.append(operator.type().precedence() < op.type().precedence() ? this.toInnerString(op) : this.bracket(op));
            sb.append(opString);
        }
        if (last != null) {
            sb.append(operator.type().precedence() < last.type().precedence() ? this.toInnerString(last) : this.bracket(last));
        }
        return sb.toString();
    }

    @Override
    protected String pbLhs(Literal[] operands, int[] coefficients) {
        assert (operands.length == coefficients.length);
        ArrayList<Literal> sortedOperands = new ArrayList<Literal>();
        ArrayList<Integer> sortedCoefficients = new ArrayList<Integer>();
        List<Literal> givenOperands = Arrays.asList(operands);
        for (Variable v : this.varOrder) {
            int index = givenOperands.indexOf(v);
            if (index == -1) continue;
            sortedOperands.add(v);
            sortedCoefficients.add(coefficients[index]);
        }
        for (Literal givenOperand : givenOperands) {
            if (sortedOperands.contains(givenOperand)) continue;
            sortedOperands.add(givenOperand);
            sortedCoefficients.add(coefficients[givenOperands.indexOf(givenOperand)]);
        }
        StringBuilder sb = new StringBuilder();
        String mul = this.pbMul();
        String add = this.pbAdd();
        for (int i = 0; i < sortedOperands.size() - 1; ++i) {
            if ((Integer)sortedCoefficients.get(i) != 1) {
                sb.append(sortedCoefficients.get(i)).append(mul).append(sortedOperands.get(i)).append(add);
                continue;
            }
            sb.append(sortedOperands.get(i)).append(add);
        }
        if (sortedOperands.size() > 0) {
            if ((Integer)sortedCoefficients.get(sortedOperands.size() - 1) != 1) {
                sb.append(sortedCoefficients.get(sortedOperands.size() - 1)).append(mul).append(sortedOperands.get(sortedOperands.size() - 1));
            } else {
                sb.append(sortedOperands.get(sortedOperands.size() - 1));
            }
        }
        return sb.toString();
    }

    private String sortedEquivalence(Equivalence equivalence) {
        Formula left;
        Formula right;
        if (this.comparator.compare(equivalence.left(), equivalence.right()) <= 0) {
            right = equivalence.right();
            left = equivalence.left();
        } else {
            right = equivalence.left();
            left = equivalence.right();
        }
        String leftString = FType.EQUIV.precedence() < left.type().precedence() ? this.toInnerString(left) : this.bracket(left);
        String rightString = FType.EQUIV.precedence() < right.type().precedence() ? this.toInnerString(right) : this.bracket(right);
        return String.format("%s%s%s", leftString, this.equivalence(), rightString);
    }

    static class FormulaComparator
    implements Comparator<Formula> {
        final List<Variable> varOrder;

        FormulaComparator(List<Variable> varOrder) {
            this.varOrder = varOrder;
        }

        @Override
        public int compare(Formula formula1, Formula formula2) {
            TreeSet<Variable> vars1 = new TreeSet<Variable>(formula1.variables());
            TreeSet<Variable> vars2 = new TreeSet<Variable>(formula2.variables());
            for (Variable v : this.varOrder) {
                if (vars1.isEmpty() && vars2.isEmpty()) break;
                if (vars1.isEmpty() || vars1.contains(v) && !vars2.contains(v)) {
                    return -1;
                }
                if (vars2.isEmpty() || !vars1.contains(v) && vars2.contains(v)) {
                    return 1;
                }
                if (!vars1.contains(v) || !vars2.contains(v)) continue;
                vars1.remove(v);
                vars2.remove(v);
            }
            return (int)formula1.numberOfAtoms() - (int)formula2.numberOfAtoms();
        }
    }
}

