/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas.printer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logicng.formulas.CType;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.printer.FormulaStringRepresentation;

public final class LatexStringRepresentation
extends FormulaStringRepresentation {
    private static final Pattern pattern = Pattern.compile("(.*?)(\\d*)");

    private static String latexName(String name) {
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            return name;
        }
        if (matcher.group(2).isEmpty()) {
            return matcher.group(1);
        }
        return matcher.group(1) + "_{" + matcher.group(2) + "}";
    }

    @Override
    public String toInnerString(Formula formula) {
        if (formula.type() == FType.LITERAL) {
            Literal lit = (Literal)formula;
            return lit.phase() ? LatexStringRepresentation.latexName(lit.name()) : this.negation() + " " + LatexStringRepresentation.latexName(lit.name());
        }
        return super.toInnerString(formula);
    }

    @Override
    protected String falsum() {
        return "\\bottom";
    }

    @Override
    protected String verum() {
        return "\\top";
    }

    @Override
    protected String negation() {
        return "\\lnot";
    }

    @Override
    protected String implication() {
        return " \\rightarrow ";
    }

    @Override
    protected String equivalence() {
        return " \\leftrightarrow ";
    }

    @Override
    protected String and() {
        return " \\land ";
    }

    @Override
    protected String or() {
        return " \\lor ";
    }

    @Override
    protected String pbComparator(CType comparator) {
        switch (comparator) {
            case EQ: {
                return " = ";
            }
            case LE: {
                return " \\leq ";
            }
            case LT: {
                return " < ";
            }
            case GE: {
                return " \\geq ";
            }
            case GT: {
                return " > ";
            }
        }
        throw new IllegalArgumentException("Unknown pseudo-Boolean comparison: " + (Object)((Object)comparator));
    }

    @Override
    protected String pbMul() {
        return "\\cdot ";
    }

    @Override
    protected String pbAdd() {
        return " + ";
    }

    @Override
    protected String lbr() {
        return "\\left(";
    }

    @Override
    protected String rbr() {
        return "\\right)";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

