/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas.printer;

import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.CType;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.Not;
import org.logicng.formulas.PBConstraint;

public abstract class FormulaStringRepresentation {
    public String toString(Formula formula) {
        return this.toInnerString(formula);
    }

    protected String toInnerString(Formula formula) {
        switch (formula.type()) {
            case FALSE: {
                return this.falsum();
            }
            case TRUE: {
                return this.verum();
            }
            case LITERAL: {
                Literal lit = (Literal)formula;
                return lit.phase() ? lit.name() : this.negation() + lit.name();
            }
            case NOT: {
                Not not = (Not)formula;
                return this.negation() + this.bracket(not.operand());
            }
            case IMPL: 
            case EQUIV: {
                BinaryOperator binary = (BinaryOperator)formula;
                String op = formula.type() == FType.IMPL ? this.implication() : this.equivalence();
                return this.binaryOperator(binary, op);
            }
            case AND: 
            case OR: {
                NAryOperator nary = (NAryOperator)formula;
                String op = formula.type() == FType.AND ? this.and() : this.or();
                return this.naryOperator(nary, String.format("%s", op));
            }
            case PBC: {
                PBConstraint pbc = (PBConstraint)formula;
                return String.format("%s%s%d", this.pbLhs(pbc.operands(), pbc.coefficients()), this.pbComparator(pbc.comparator()), pbc.rhs());
            }
        }
        throw new IllegalArgumentException("Cannot print the unknown formula type " + (Object)((Object)formula.type()));
    }

    protected String bracket(Formula formula) {
        return String.format("%s%s%s", this.lbr(), this.toInnerString(formula), this.rbr());
    }

    protected String binaryOperator(BinaryOperator operator, String opString) {
        String leftString = operator.type().precedence() < operator.left().type().precedence() ? this.toInnerString(operator.left()) : this.bracket(operator.left());
        String rightString = operator.type().precedence() < operator.right().type().precedence() ? this.toInnerString(operator.right()) : this.bracket(operator.right());
        return String.format("%s%s%s", leftString, opString, rightString);
    }

    protected String naryOperator(NAryOperator operator, String opString) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int size = operator.numberOfOperands();
        Formula last = null;
        for (Formula op : operator) {
            if (++count == size) {
                last = op;
                continue;
            }
            sb.append(operator.type().precedence() < op.type().precedence() ? this.toInnerString(op) : this.bracket(op));
            sb.append(opString);
        }
        if (last != null) {
            sb.append(operator.type().precedence() < last.type().precedence() ? this.toInnerString(last) : this.bracket(last));
        }
        return sb.toString();
    }

    protected String pbLhs(Literal[] operands, int[] coefficients) {
        assert (operands.length == coefficients.length);
        StringBuilder sb = new StringBuilder();
        String mul = this.pbMul();
        String add = this.pbAdd();
        for (int i = 0; i < operands.length - 1; ++i) {
            if (coefficients[i] != 1) {
                sb.append(coefficients[i]).append(mul).append(operands[i]).append(add);
                continue;
            }
            sb.append(operands[i]).append(add);
        }
        if (operands.length > 0) {
            if (coefficients[operands.length - 1] != 1) {
                sb.append(coefficients[operands.length - 1]).append(mul).append(operands[operands.length - 1]);
            } else {
                sb.append(operands[operands.length - 1]);
            }
        }
        return sb.toString();
    }

    protected abstract String falsum();

    protected abstract String verum();

    protected abstract String negation();

    protected abstract String implication();

    protected abstract String equivalence();

    protected abstract String and();

    protected abstract String or();

    protected abstract String pbComparator(CType var1);

    protected abstract String pbMul();

    protected abstract String pbAdd();

    protected abstract String lbr();

    protected abstract String rbr();
}

