/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas.printer;

import org.logicng.formulas.CType;
import org.logicng.formulas.printer.FormulaStringRepresentation;

public class DefaultStringRepresentation
extends FormulaStringRepresentation {
    @Override
    protected String falsum() {
        return "$false";
    }

    @Override
    protected String verum() {
        return "$true";
    }

    @Override
    protected String negation() {
        return "~";
    }

    @Override
    protected String implication() {
        return " => ";
    }

    @Override
    protected String equivalence() {
        return " <=> ";
    }

    @Override
    protected String and() {
        return " & ";
    }

    @Override
    protected String or() {
        return " | ";
    }

    @Override
    protected String pbComparator(CType comparator) {
        switch (comparator) {
            case EQ: {
                return " = ";
            }
            case LE: {
                return " <= ";
            }
            case LT: {
                return " < ";
            }
            case GE: {
                return " >= ";
            }
            case GT: {
                return " > ";
            }
        }
        throw new IllegalArgumentException("Unknown pseudo-Boolean comparison: " + (Object)((Object)comparator));
    }

    @Override
    protected String pbMul() {
        return "*";
    }

    @Override
    protected String pbAdd() {
        return " + ";
    }

    @Override
    protected String lbr() {
        return "(";
    }

    @Override
    protected String rbr() {
        return ")";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

