/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Substitution;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.CType;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.formulas.cache.TransformationCacheEntry;
import org.logicng.util.FormulaHelper;
import org.logicng.util.Pair;

public class PBConstraint
extends Formula {
    private static final Iterator<Formula> ITERATOR = new Iterator<Formula>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Formula next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    protected final Literal[] literals;
    protected final int[] coefficients;
    protected CType comparator;
    protected int rhs;
    protected List<Formula> encoding;
    protected int hashCode;
    protected int maxWeight;

    PBConstraint(Literal[] literals, int[] coefficients, CType comparator, int rhs, FormulaFactory f) {
        super(FType.PBC, f);
        if (literals.length != coefficients.length) {
            throw new IllegalArgumentException("Cannot generate a pseudo-Boolean constraint with literals.length != coefficients.length");
        }
        this.literals = literals;
        this.coefficients = coefficients;
        this.maxWeight = Integer.MIN_VALUE;
        for (int c : coefficients) {
            if (c <= this.maxWeight) continue;
            this.maxWeight = c;
        }
        this.comparator = comparator;
        this.rhs = rhs;
        this.encoding = null;
        this.hashCode = 0;
    }

    private static int gcd(int small, int big) {
        return small == 0 ? big : PBConstraint.gcd(big % small, small);
    }

    static Tristate evaluateCoeffs(int minValue, int maxValue, int rhs, CType comparator) {
        int status = 0;
        if (rhs >= minValue) {
            ++status;
        }
        if (rhs > minValue) {
            ++status;
        }
        if (rhs >= maxValue) {
            ++status;
        }
        if (rhs > maxValue) {
            ++status;
        }
        switch (comparator) {
            case EQ: {
                return status == 0 || status == 4 ? Tristate.FALSE : Tristate.UNDEF;
            }
            case LE: {
                return status >= 3 ? Tristate.TRUE : (status < 1 ? Tristate.FALSE : Tristate.UNDEF);
            }
            case LT: {
                return status > 3 ? Tristate.TRUE : (status <= 1 ? Tristate.FALSE : Tristate.UNDEF);
            }
            case GE: {
                return status <= 1 ? Tristate.TRUE : (status > 3 ? Tristate.FALSE : Tristate.UNDEF);
            }
            case GT: {
                return status < 1 ? Tristate.TRUE : (status >= 3 ? Tristate.FALSE : Tristate.UNDEF);
            }
        }
        throw new IllegalStateException("Unknown pseudo-Boolean comparator: " + (Object)((Object)comparator));
    }

    public Literal[] operands() {
        return Arrays.copyOf(this.literals, this.literals.length);
    }

    public int[] coefficients() {
        return Arrays.copyOf(this.coefficients, this.coefficients.length);
    }

    public CType comparator() {
        return this.comparator;
    }

    public int rhs() {
        return this.rhs;
    }

    public boolean isCC() {
        return false;
    }

    public boolean isAmo() {
        return false;
    }

    public boolean isExo() {
        return false;
    }

    public int maxWeight() {
        return this.maxWeight;
    }

    public Formula normalize() {
        LNGVector<Literal> normPs = new LNGVector<Literal>(this.literals.length);
        LNGIntVector normCs = new LNGIntVector(this.literals.length);
        switch (this.comparator) {
            case EQ: {
                for (int i = 0; i < this.literals.length; ++i) {
                    normPs.push(this.literals[i]);
                    normCs.push(this.coefficients[i]);
                }
                int normRhs = this.rhs;
                Formula f1 = this.normalize(normPs, normCs, normRhs);
                normPs.clear();
                normCs.clear();
                for (int i = 0; i < this.literals.length; ++i) {
                    normPs.push(this.literals[i]);
                    normCs.push(-this.coefficients[i]);
                }
                normRhs = -this.rhs;
                Formula f2 = this.normalize(normPs, normCs, normRhs);
                return this.f.and(f1, f2);
            }
            case LE: 
            case LT: {
                for (int i = 0; i < this.literals.length; ++i) {
                    normPs.push(this.literals[i]);
                    normCs.push(this.coefficients[i]);
                }
                int normRhs = this.comparator == CType.LE ? this.rhs : this.rhs - 1;
                return this.normalize(normPs, normCs, normRhs);
            }
            case GE: 
            case GT: {
                for (int i = 0; i < this.literals.length; ++i) {
                    normPs.push(this.literals[i]);
                    normCs.push(-this.coefficients[i]);
                }
                int normRhs = this.comparator == CType.GE ? -this.rhs : -this.rhs - 1;
                return this.normalize(normPs, normCs, normRhs);
            }
        }
        throw new IllegalStateException("Unknown pseudo-Boolean comparator: " + (Object)((Object)this.comparator));
    }

    /*
     * WARNING - void declaration
     */
    private Formula normalize(LNGVector<Literal> ps, LNGIntVector cs, int rhs) {
        int i;
        boolean changed;
        void var9_18;
        int c = rhs;
        int newSize = 0;
        for (int i2 = 0; i2 < ps.size(); ++i2) {
            if (cs.get(i2) == 0) continue;
            ps.set(newSize, ps.get(i2));
            cs.set(newSize, cs.get(i2));
            ++newSize;
        }
        ps.removeElements(ps.size() - newSize);
        cs.removeElements(cs.size() - newSize);
        TreeMap<Object, Pair<Integer, Object>> var2consts = new TreeMap<Object, Pair<Integer, Object>>();
        for (int i3 = 0; i3 < ps.size(); ++i3) {
            void var9_12;
            Variable x = ps.get(i3).variable();
            Pair pair = (Pair)var2consts.get(x);
            if (pair == null) {
                Pair<Integer, Integer> pair2 = new Pair<Integer, Integer>(0, 0);
            }
            if (!ps.get(i3).phase()) {
                var2consts.put(x, new Pair((Integer)var9_12.first() + cs.get(i3), var9_12.second()));
                continue;
            }
            var2consts.put(x, new Pair(var9_12.first(), (Integer)var9_12.second() + cs.get(i3)));
        }
        LNGVector<Pair<Integer, Object>> csps = new LNGVector<Pair<Integer, Object>>(var2consts.size());
        for (Map.Entry entry : var2consts.entrySet()) {
            if ((Integer)((Pair)entry.getValue()).first() < (Integer)((Pair)entry.getValue()).second()) {
                c -= ((Integer)((Pair)entry.getValue()).first()).intValue();
                csps.push(new Pair((Integer)((Pair)entry.getValue()).second() - (Integer)((Pair)entry.getValue()).first(), entry.getKey()));
                continue;
            }
            c -= ((Integer)((Pair)entry.getValue()).second()).intValue();
            csps.push(new Pair<Integer, Literal>((Integer)((Pair)entry.getValue()).first() - (Integer)((Pair)entry.getValue()).second(), ((Literal)entry.getKey()).negate()));
        }
        int sum = 0;
        boolean bl = false;
        cs.clear();
        ps.clear();
        for (Pair pair : csps) {
            if ((Integer)pair.first() != 0) {
                cs.push((Integer)pair.first());
                ps.push((Literal)pair.second());
                sum += cs.back();
                continue;
            }
            ++var9_18;
        }
        ps.removeElements(ps.size() - csps.size() - var9_18);
        cs.removeElements(cs.size() - csps.size() - var9_18);
        do {
            changed = false;
            if (c < 0) {
                return this.f.falsum();
            }
            if (sum <= c) {
                return this.f.verum();
            }
            assert (cs.size() > 0);
            int n = c;
            for (i = 0; i < cs.size(); ++i) {
                n = PBConstraint.gcd(n, cs.get(i));
            }
            if (n != 0 && n != 1) {
                for (i = 0; i < cs.size(); ++i) {
                    cs.set(i, cs.get(i) / n);
                }
                c /= n;
            }
            if (n == 1 || n == 0) continue;
            changed = true;
        } while (changed);
        Literal[] literalArray = new Literal[ps.size()];
        for (i = 0; i < literalArray.length; ++i) {
            literalArray[i] = ps.get(i);
        }
        int[] coeffs = new int[cs.size()];
        for (int i4 = 0; i4 < coeffs.length; ++i4) {
            coeffs[i4] = cs.get(i4);
        }
        return this.f.pbc(CType.LE, c, literalArray, coeffs);
    }

    @Override
    public long numberOfAtoms() {
        return 1L;
    }

    @Override
    public long numberOfNodes() {
        if (this.numberOfNodes != -1L) {
            return this.numberOfNodes;
        }
        this.numberOfNodes = 1L + (long)this.literals.length;
        return this.numberOfNodes;
    }

    @Override
    public int numberOfOperands() {
        return 0;
    }

    @Override
    public boolean isConstantFormula() {
        return false;
    }

    @Override
    public boolean isAtomicFormula() {
        return true;
    }

    @Override
    public SortedSet<Variable> variables() {
        if (this.variables == null) {
            this.variables = Collections.unmodifiableSortedSet(FormulaHelper.variables(this.literals));
        }
        return this.variables;
    }

    @Override
    public SortedSet<Literal> literals() {
        return Collections.unmodifiableSortedSet(FormulaHelper.literals(this.literals));
    }

    @Override
    public boolean containsVariable(Variable variable) {
        for (Literal lit : this.literals) {
            if (!lit.containsVariable(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(Assignment assignment) {
        int lhs = this.evaluateLHS(assignment);
        return this.evaluateComparator(lhs);
    }

    @Override
    public Formula restrict(Assignment assignment) {
        ArrayList<Literal> newLits = new ArrayList<Literal>();
        ArrayList<Integer> newCoeffs = new ArrayList<Integer>();
        int lhsFixed = 0;
        int minValue = 0;
        int maxValue = 0;
        for (int i = 0; i < this.literals.length; ++i) {
            Formula restriction = assignment.restrictLit(this.literals[i]);
            if (restriction.type == FType.LITERAL) {
                newLits.add(this.literals[i]);
                int coeff = this.coefficients[i];
                newCoeffs.add(coeff);
                if (coeff > 0) {
                    maxValue += coeff;
                    continue;
                }
                minValue += coeff;
                continue;
            }
            if (restriction.type != FType.TRUE) continue;
            lhsFixed += this.coefficients[i];
        }
        if (newLits.isEmpty()) {
            return this.f.constant(this.evaluateComparator(lhsFixed));
        }
        int newRHS = this.rhs - lhsFixed;
        if (this.comparator != CType.EQ) {
            Tristate fixed = PBConstraint.evaluateCoeffs(minValue, maxValue, newRHS, this.comparator);
            if (fixed == Tristate.TRUE) {
                return this.f.verum();
            }
            if (fixed == Tristate.FALSE) {
                return this.f.falsum();
            }
        }
        return this.f.pbc(this.comparator, newRHS, newLits, newCoeffs);
    }

    @Override
    public boolean containsNode(Formula formula) {
        if (this == formula || this.equals(formula)) {
            return true;
        }
        if (formula.type == FType.LITERAL) {
            for (Literal lit : this.literals) {
                if (!lit.equals(formula) && !lit.variable().equals(formula)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Formula substitute(Substitution substitution) {
        ArrayList<Literal> newLits = new ArrayList<Literal>();
        ArrayList<Integer> newCoeffs = new ArrayList<Integer>();
        int lhsFixed = 0;
        block5: for (int i = 0; i < this.literals.length; ++i) {
            Formula subst = substitution.getSubstitution(this.literals[i].variable());
            if (subst == null) {
                newLits.add(this.literals[i]);
                newCoeffs.add(this.coefficients[i]);
                continue;
            }
            switch (subst.type) {
                case TRUE: {
                    if (!this.literals[i].phase()) continue block5;
                    lhsFixed += this.coefficients[i];
                    continue block5;
                }
                case FALSE: {
                    if (this.literals[i].phase()) continue block5;
                    lhsFixed += this.coefficients[i];
                    continue block5;
                }
                case LITERAL: {
                    newLits.add(this.literals[i].phase() ? (Literal)subst : ((Literal)subst).negate());
                    newCoeffs.add(this.coefficients[i]);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Cannot substitute a formula for a literal in a pseudo-Boolean constraint");
                }
            }
        }
        return newLits.isEmpty() ? (this.evaluateComparator(lhsFixed) ? this.f.verum() : this.f.falsum()) : this.f.pbc(this.comparator, this.rhs - lhsFixed, newLits, newCoeffs);
    }

    @Override
    public Formula negate() {
        switch (this.comparator) {
            case EQ: {
                return this.f.or(this.f.pbc(CType.LT, this.rhs, this.literals, this.coefficients), this.f.pbc(CType.GT, this.rhs, this.literals, this.coefficients));
            }
            case LE: {
                return this.f.pbc(CType.GT, this.rhs, this.literals, this.coefficients);
            }
            case LT: {
                return this.f.pbc(CType.GE, this.rhs, this.literals, this.coefficients);
            }
            case GE: {
                return this.f.pbc(CType.LT, this.rhs, this.literals, this.coefficients);
            }
            case GT: {
                return this.f.pbc(CType.LE, this.rhs, this.literals, this.coefficients);
            }
        }
        throw new IllegalStateException("Unknown pseudo-Boolean comparator");
    }

    @Override
    public Formula nnf() {
        Formula nnf = (Formula)this.transformationCache.get(TransformationCacheEntry.NNF);
        if (nnf == null) {
            if (this.encoding == null) {
                this.encode();
            }
            nnf = this.f.and(this.encoding);
            this.setTransformationCacheEntry(TransformationCacheEntry.NNF, nnf);
        }
        return nnf;
    }

    private int evaluateLHS(Assignment assignment) {
        int lhs = 0;
        for (int i = 0; i < this.literals.length; ++i) {
            if (!this.literals[i].evaluate(assignment)) continue;
            lhs += this.coefficients[i];
        }
        return lhs;
    }

    private boolean evaluateComparator(int lhs) {
        switch (this.comparator) {
            case EQ: {
                return lhs == this.rhs;
            }
            case LE: {
                return lhs <= this.rhs;
            }
            case LT: {
                return lhs < this.rhs;
            }
            case GE: {
                return lhs >= this.rhs;
            }
            case GT: {
                return lhs > this.rhs;
            }
        }
        throw new IllegalStateException("Unknown pseudo-Boolean comparator");
    }

    private void encode() {
        this.encoding = this.f.pbEncoder().encode(this);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int temp = this.comparator.hashCode() + this.rhs;
            for (int i = 0; i < this.literals.length; ++i) {
                temp += 11 * this.literals[i].hashCode();
                temp += 13 * this.coefficients[i];
            }
            this.hashCode = temp;
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Formula && this.f == ((Formula)other).f) {
            return false;
        }
        if (other instanceof PBConstraint) {
            PBConstraint o = (PBConstraint)other;
            return this.rhs == o.rhs && this.comparator == o.comparator && Arrays.equals(this.coefficients, o.coefficients) && Arrays.equals(this.literals, o.literals);
        }
        return false;
    }

    @Override
    public Iterator<Formula> iterator() {
        return ITERATOR;
    }

    @Override
    public Stream<Formula> stream() {
        return Stream.empty();
    }
}

