/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.LinkedHashSet;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.formulas.cache.PredicateCacheEntry;
import org.logicng.formulas.cache.TransformationCacheEntry;

public final class Or
extends NAryOperator {
    private final boolean isCNFClause;

    Or(LinkedHashSet<? extends Formula> operands, FormulaFactory f, boolean isClause) {
        super(FType.OR, operands, f);
        if (isClause) {
            this.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_CNF, true);
            this.setTransformationCacheEntry(TransformationCacheEntry.FACTORIZED_CNF, this);
            this.isCNFClause = true;
        } else {
            this.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_CNF, false);
            this.isCNFClause = false;
        }
    }

    @Override
    public boolean evaluate(Assignment assignment) {
        for (Formula op : this.operands) {
            if (!op.evaluate(assignment)) continue;
            return true;
        }
        return false;
    }

    public boolean isCNFClause() {
        return this.isCNFClause;
    }

    public int hashCode() {
        return this.hashCode(17);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Formula && this.f == ((Formula)other).f) {
            return false;
        }
        if (other instanceof Or) {
            return this.compareOperands(((Or)other).operands);
        }
        return false;
    }
}

