/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Substitution;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.formulas.cache.TransformationCacheEntry;

public final class Not
extends Formula {
    private final Formula operand;
    private volatile int hashCode;

    Not(Formula operand, FormulaFactory f) {
        super(FType.NOT, f);
        this.operand = operand;
        this.hashCode = 0;
    }

    public Formula operand() {
        return this.operand;
    }

    @Override
    public long numberOfAtoms() {
        if (this.numberOfAtoms != -1L) {
            return this.numberOfAtoms;
        }
        this.numberOfAtoms = this.operand.numberOfAtoms();
        return this.numberOfAtoms;
    }

    @Override
    public long numberOfNodes() {
        if (this.numberOfNodes != -1L) {
            return this.numberOfNodes;
        }
        this.numberOfNodes = this.operand.numberOfNodes() + 1L;
        return this.numberOfNodes;
    }

    @Override
    public int numberOfOperands() {
        return 1;
    }

    @Override
    public boolean isConstantFormula() {
        return false;
    }

    @Override
    public boolean isAtomicFormula() {
        return false;
    }

    @Override
    public SortedSet<Variable> variables() {
        if (this.variables == null) {
            this.variables = Collections.unmodifiableSortedSet(this.operand.variables());
        }
        return this.variables;
    }

    @Override
    public SortedSet<Literal> literals() {
        return this.operand.literals();
    }

    @Override
    public boolean containsVariable(Variable variable) {
        return this.operand.containsVariable(variable);
    }

    @Override
    public boolean evaluate(Assignment assignment) {
        return !this.operand.evaluate(assignment);
    }

    @Override
    public Formula restrict(Assignment assignment) {
        return this.f.not(this.operand.restrict(assignment));
    }

    @Override
    public boolean containsNode(Formula formula) {
        return this == formula || this.equals(formula) || this.operand.containsNode(formula);
    }

    @Override
    public Formula substitute(Substitution substitution) {
        return this.f.not(this.operand.substitute(substitution));
    }

    @Override
    public Formula negate() {
        return this.operand;
    }

    @Override
    public Formula nnf() {
        Formula nnf = (Formula)this.transformationCache.get(TransformationCacheEntry.NNF);
        if (nnf == null) {
            switch (this.operand.type) {
                case AND: 
                case OR: {
                    LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>();
                    for (Formula op : this.operand) {
                        nops.add(op.negate().nnf());
                    }
                    nnf = this.f.naryOperator(FType.dual(this.operand.type), nops);
                    break;
                }
                case IMPL: {
                    BinaryOperator impl = (BinaryOperator)this.operand;
                    nnf = this.f.and(impl.left.nnf(), impl.right.negate().nnf());
                    break;
                }
                case EQUIV: {
                    BinaryOperator equiv = (BinaryOperator)this.operand;
                    nnf = this.f.and(this.f.or(equiv.left.negate().nnf(), equiv.right.negate().nnf()), this.f.or(equiv.left.nnf(), equiv.right.nnf()));
                    break;
                }
                case PBC: {
                    nnf = this.operand.negate().nnf();
                    break;
                }
                default: {
                    throw new IllegalStateException("Did not expect formula of type: " + (Object)((Object)this.operand.type()));
                }
            }
            this.transformationCache.put(TransformationCacheEntry.NNF, nnf);
        }
        return nnf;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 29 * this.operand.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Formula && this.f == ((Formula)other).f) {
            return false;
        }
        if (other instanceof Not) {
            Not otherNot = (Not)other;
            return this.operand.equals(otherNot.operand);
        }
        return false;
    }

    @Override
    public Iterator<Formula> iterator() {
        return new Iterator<Formula>(){
            private boolean iterated;

            @Override
            public boolean hasNext() {
                return !this.iterated;
            }

            @Override
            public Formula next() {
                if (!this.iterated) {
                    this.iterated = true;
                    return Not.this.operand;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Stream<Formula> stream() {
        return Stream.of(this.operand);
    }
}

