/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Substitution;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.formulas.cache.TransformationCacheEntry;
import org.logicng.util.FormulaHelper;

public abstract class NAryOperator
extends Formula {
    protected final Formula[] operands;
    private volatile int hashCode;

    NAryOperator(FType type, Collection<? extends Formula> operands, FormulaFactory f) {
        super(type, f);
        this.operands = operands.toArray(new Formula[0]);
        this.hashCode = 0;
    }

    @Override
    public long numberOfAtoms() {
        if (this.numberOfAtoms != -1L) {
            return this.numberOfAtoms;
        }
        this.numberOfAtoms = 0L;
        for (Formula f : this.operands) {
            this.numberOfAtoms += f.numberOfAtoms();
        }
        return this.numberOfAtoms;
    }

    @Override
    public long numberOfNodes() {
        if (this.numberOfNodes != -1L) {
            return this.numberOfNodes;
        }
        this.numberOfNodes = 1L;
        for (Formula f : this.operands) {
            this.numberOfNodes += f.numberOfNodes();
        }
        return this.numberOfNodes;
    }

    @Override
    public int numberOfOperands() {
        return this.operands.length;
    }

    @Override
    public boolean isConstantFormula() {
        return false;
    }

    @Override
    public boolean isAtomicFormula() {
        return false;
    }

    @Override
    public SortedSet<Variable> variables() {
        if (this.variables == null) {
            this.variables = Collections.unmodifiableSortedSet(FormulaHelper.variables(this.operands));
        }
        return this.variables;
    }

    @Override
    public SortedSet<Literal> literals() {
        return Collections.unmodifiableSortedSet(FormulaHelper.literals(this.operands));
    }

    @Override
    public boolean containsVariable(Variable variable) {
        for (Formula op : this.operands) {
            if (!op.containsVariable(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Formula restrict(Assignment assignment) {
        LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>();
        for (Formula op : this.operands) {
            nops.add(op.restrict(assignment));
        }
        return this.f.naryOperator(this.type, nops);
    }

    @Override
    public boolean containsNode(Formula formula) {
        if (this.equals(formula)) {
            return true;
        }
        if (this.type != formula.type) {
            for (Formula op : this.operands) {
                if (!op.containsNode(formula)) continue;
                return true;
            }
            return false;
        }
        ArrayList<Formula> fOps = new ArrayList<Formula>(formula.numberOfOperands());
        for (Formula op : formula) {
            fOps.add(op);
        }
        for (Formula op : this.operands) {
            fOps.remove(op);
            if (!op.containsNode(formula)) continue;
            return true;
        }
        return fOps.isEmpty();
    }

    @Override
    public Formula substitute(Substitution substitution) {
        LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>();
        for (Formula op : this.operands) {
            nops.add(op.substitute(substitution));
        }
        return this.f.naryOperator(this.type, nops);
    }

    @Override
    public Formula negate() {
        return this.f.not(this);
    }

    @Override
    public Formula nnf() {
        Formula nnf = (Formula)this.transformationCache.get(TransformationCacheEntry.NNF);
        if (nnf == null) {
            LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>();
            for (Formula op : this.operands) {
                nops.add(op.nnf());
            }
            nnf = this.f.naryOperator(this.type, nops);
            this.transformationCache.put(TransformationCacheEntry.NNF, nnf);
        }
        return nnf;
    }

    protected int hashCode(int shift) {
        if (this.hashCode == 0) {
            int temp = 1;
            for (Formula formula : this.operands) {
                temp += formula.hashCode();
            }
            this.hashCode = temp *= shift;
        }
        return this.hashCode;
    }

    protected boolean compareOperands(Formula[] other) {
        if (this.operands.length != other.length) {
            return false;
        }
        for (Formula op1 : this.operands) {
            boolean found = false;
            for (Formula op2 : other) {
                if (!op1.equals(op2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Formula> iterator() {
        return new Iterator<Formula>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < NAryOperator.this.operands.length;
            }

            @Override
            public Formula next() {
                if (this.i == NAryOperator.this.operands.length) {
                    throw new NoSuchElementException();
                }
                return NAryOperator.this.operands[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Stream<Formula> stream() {
        return Stream.of(this.operands);
    }
}

