/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Substitution;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Variable;

public class Literal
extends Formula
implements Comparable<Literal> {
    private static final Iterator<Formula> ITERATOR = new Iterator<Formula>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Formula next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private final String name;
    private final boolean phase;
    private final SortedSet<Literal> literals;
    private final Variable var;
    private volatile Literal negated;
    private volatile int hashCode;

    Literal(String name, boolean phase, FormulaFactory f) {
        super(FType.LITERAL, f);
        this.name = name;
        this.phase = phase;
        this.var = phase ? (Variable)this : (Variable)this.negate();
        this.variables = Collections.unmodifiableSortedSet(new TreeSet<Variable>(Collections.singletonList(this.var)));
        this.literals = Collections.unmodifiableSortedSet(new TreeSet<Literal>(Collections.singletonList(this)));
    }

    @Override
    public FormulaFactory factory() {
        return this.f;
    }

    @Override
    public long numberOfAtoms() {
        return 1L;
    }

    @Override
    public long numberOfNodes() {
        return 1L;
    }

    @Override
    public int numberOfOperands() {
        return 0;
    }

    @Override
    public boolean isConstantFormula() {
        return false;
    }

    @Override
    public boolean isAtomicFormula() {
        return true;
    }

    @Override
    public SortedSet<Variable> variables() {
        return this.variables;
    }

    @Override
    public SortedSet<Literal> literals() {
        return this.literals;
    }

    @Override
    public boolean containsVariable(Variable variable) {
        return variable.name().equals(this.name);
    }

    @Override
    public boolean evaluate(Assignment assignment) {
        return assignment.evaluateLit(this);
    }

    @Override
    public Formula restrict(Assignment assignment) {
        return assignment.restrictLit(this);
    }

    @Override
    public boolean containsNode(Formula formula) {
        return this.equals(formula);
    }

    @Override
    public Formula substitute(Substitution substitution) {
        Formula subst = substitution.getSubstitution(this.variable());
        return subst == null ? this : (this.phase ? subst : subst.negate());
    }

    @Override
    public Literal negate() {
        if (this.negated != null) {
            return this.negated;
        }
        this.negated = this.f.literal(this.name, !this.phase);
        return this.negated;
    }

    @Override
    public Formula nnf() {
        return this;
    }

    public String name() {
        return this.name;
    }

    public boolean phase() {
        return this.phase;
    }

    public Variable variable() {
        return this.var;
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = this.name.hashCode() ^ (this.phase ? 1 : 0);
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Formula && this.f == ((Formula)other).f) {
            return false;
        }
        if (other instanceof Literal) {
            Literal otherLit = (Literal)other;
            return this.phase == otherLit.phase && this.name.equals(otherLit.name);
        }
        return false;
    }

    @Override
    public int compareTo(Literal lit) {
        if (this == lit) {
            return 0;
        }
        int res = this.name.compareTo(lit.name);
        if (res == 0 && this.phase != lit.phase) {
            return this.phase ? -1 : 1;
        }
        return res;
    }

    @Override
    public Iterator<Formula> iterator() {
        return ITERATOR;
    }

    @Override
    public Stream<Formula> stream() {
        return Stream.empty();
    }
}

