/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import org.logicng.datastructures.Assignment;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.cache.TransformationCacheEntry;

public final class Implication
extends BinaryOperator {
    Implication(Formula left, Formula right, FormulaFactory f) {
        super(FType.IMPL, left, right, f);
    }

    @Override
    public boolean evaluate(Assignment assignment) {
        return !this.left.evaluate(assignment) || this.right.evaluate(assignment);
    }

    @Override
    public Formula restrict(Assignment assignment) {
        return this.f.implication(this.left.restrict(assignment), this.right.restrict(assignment));
    }

    @Override
    public Formula nnf() {
        Formula nnf = (Formula)this.transformationCache.get(TransformationCacheEntry.NNF);
        if (nnf == null) {
            nnf = this.f.or(this.f.not(this.left).nnf(), this.right.nnf());
            this.transformationCache.put(TransformationCacheEntry.NNF, nnf);
        }
        return nnf;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * this.left.hashCode() + 39 * this.right.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Formula && this.f == ((Formula)other).f) {
            return false;
        }
        if (other instanceof Implication) {
            Implication otherImp = (Implication)other;
            return this.left.equals(otherImp.left) && this.right.equals(otherImp.right);
        }
        return false;
    }
}

