/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.function.Supplier;
import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;
import org.logicng.formulas.printer.DefaultStringRepresentation;
import org.logicng.formulas.printer.FormulaStringRepresentation;

public final class FormulaFactoryConfig
extends Configuration {
    final String name;
    final FormulaMergeStrategy formulaMergeStrategy;
    final Supplier<FormulaStringRepresentation> stringRepresentation;
    final boolean simplifyComplementaryOperands;

    private FormulaFactoryConfig(Builder builder) {
        super(ConfigurationType.FORMULA_FACTORY);
        this.name = builder.name;
        this.formulaMergeStrategy = builder.formulaMergeStrategy;
        this.stringRepresentation = builder.stringRepresentation;
        this.simplifyComplementaryOperands = builder.simplifyComplementaryOperands;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name = "";
        private FormulaMergeStrategy formulaMergeStrategy = FormulaMergeStrategy.PANIC;
        private Supplier<FormulaStringRepresentation> stringRepresentation = DefaultStringRepresentation::new;
        private boolean simplifyComplementaryOperands = true;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder formulaMergeStrategy(FormulaMergeStrategy formulaMergeStrategy) {
            this.formulaMergeStrategy = formulaMergeStrategy;
            return this;
        }

        public Builder stringRepresentation(Supplier<FormulaStringRepresentation> stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
            return this;
        }

        public Builder simplifyComplementaryOperands(boolean simplifyComplementaryOperands) {
            this.simplifyComplementaryOperands = simplifyComplementaryOperands;
            return this;
        }

        public FormulaFactoryConfig build() {
            return new FormulaFactoryConfig(this);
        }
    }

    public static enum FormulaMergeStrategy {
        PANIC,
        IMPORT;

    }
}

