/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;
import org.logicng.formulas.And;
import org.logicng.formulas.CFalse;
import org.logicng.formulas.CTrue;
import org.logicng.formulas.CType;
import org.logicng.formulas.CardinalityConstraint;
import org.logicng.formulas.Constant;
import org.logicng.formulas.Equivalence;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactoryConfig;
import org.logicng.formulas.Implication;
import org.logicng.formulas.Literal;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.Not;
import org.logicng.formulas.Or;
import org.logicng.formulas.PBConstraint;
import org.logicng.formulas.Variable;
import org.logicng.formulas.printer.FormulaStringRepresentation;
import org.logicng.functions.SubNodeFunction;
import org.logicng.io.parsers.ParserException;
import org.logicng.io.parsers.PseudoBooleanParser;
import org.logicng.pseudobooleans.PBEncoder;
import org.logicng.transformations.FormulaFactoryImporter;
import org.logicng.transformations.cnf.CNFEncoder;
import org.logicng.util.Pair;

public class FormulaFactory {
    public static final String CC_PREFIX = "@RESERVED_CC_";
    public static final String PB_PREFIX = "@RESERVED_PB_";
    public static final String CNF_PREFIX = "@RESERVED_CNF_";
    private final String name;
    private final CFalse cFalse;
    private final CTrue cTrue;
    private final FormulaStringRepresentation stringRepresentation;
    private final FormulaFactoryConfig.FormulaMergeStrategy formulaMergeStrategy;
    private final boolean simplifyComplementaryOperands;
    private final Map<ConfigurationType, Configuration> configurations;
    private final String ccPrefix;
    private final String pbPrefix;
    private final String cnfPrefix;
    private final SubNodeFunction subformulaFunction;
    private final PBEncoder pbEncoder;
    private final CNFEncoder cnfEncoder;
    private final PseudoBooleanParser parser;
    Map<String, Variable> posLiterals;
    Map<String, Literal> negLiterals;
    Set<Variable> generatedVariables;
    Map<Formula, Not> nots;
    Map<Pair<Formula, Formula>, Implication> implications;
    Map<LinkedHashSet<? extends Formula>, Equivalence> equivalences;
    Map<LinkedHashSet<? extends Formula>, And> ands2;
    Map<LinkedHashSet<? extends Formula>, And> ands3;
    Map<LinkedHashSet<? extends Formula>, And> ands4;
    Map<LinkedHashSet<? extends Formula>, And> andsN;
    Map<LinkedHashSet<? extends Formula>, Or> ors2;
    Map<LinkedHashSet<? extends Formula>, Or> ors3;
    Map<LinkedHashSet<? extends Formula>, Or> ors4;
    Map<LinkedHashSet<? extends Formula>, Or> orsN;
    Map<PBOperands, PBConstraint> pbConstraints;
    Map<CCOperands, CardinalityConstraint> cardinalityConstraints;
    int ccCounter;
    int pbCounter;
    int cnfCounter;
    private boolean cnfCheck;
    private FormulaFactoryImporter importer;

    public FormulaFactory(FormulaFactoryConfig config) {
        this.name = config.name;
        this.stringRepresentation = config.stringRepresentation.get();
        this.formulaMergeStrategy = config.formulaMergeStrategy;
        this.simplifyComplementaryOperands = config.simplifyComplementaryOperands;
        this.cFalse = new CFalse(this);
        this.cTrue = new CTrue(this);
        this.clear();
        this.configurations = new EnumMap<ConfigurationType, Configuration>(ConfigurationType.class);
        this.cnfEncoder = new CNFEncoder(this);
        this.subformulaFunction = new SubNodeFunction();
        if (!this.name.isEmpty()) {
            this.ccPrefix = CC_PREFIX + this.name + "_";
            this.pbPrefix = PB_PREFIX + this.name + "_";
            this.cnfPrefix = CNF_PREFIX + this.name + "_";
        } else {
            this.ccPrefix = CC_PREFIX;
            this.pbPrefix = PB_PREFIX;
            this.cnfPrefix = CNF_PREFIX;
        }
        this.pbEncoder = new PBEncoder(this);
        this.parser = new PseudoBooleanParser(this);
    }

    public FormulaFactory() {
        this(FormulaFactoryConfig.builder().build());
    }

    private boolean containsComplement(LinkedHashSet<Formula> formulas, Formula f) {
        return this.simplifyComplementaryOperands && formulas.contains(f.negate());
    }

    public void clear() {
        this.posLiterals = new HashMap<String, Variable>();
        this.negLiterals = new HashMap<String, Literal>();
        this.generatedVariables = new HashSet<Variable>();
        this.nots = new HashMap<Formula, Not>();
        this.implications = new HashMap<Pair<Formula, Formula>, Implication>();
        this.equivalences = new HashMap<LinkedHashSet<? extends Formula>, Equivalence>();
        this.ands2 = new HashMap<LinkedHashSet<? extends Formula>, And>();
        this.ands3 = new HashMap<LinkedHashSet<? extends Formula>, And>();
        this.ands4 = new HashMap<LinkedHashSet<? extends Formula>, And>();
        this.andsN = new HashMap<LinkedHashSet<? extends Formula>, And>();
        this.ors2 = new HashMap<LinkedHashSet<? extends Formula>, Or>();
        this.ors3 = new HashMap<LinkedHashSet<? extends Formula>, Or>();
        this.ors4 = new HashMap<LinkedHashSet<? extends Formula>, Or>();
        this.orsN = new HashMap<LinkedHashSet<? extends Formula>, Or>();
        this.pbConstraints = new HashMap<PBOperands, PBConstraint>();
        this.cardinalityConstraints = new HashMap<CCOperands, CardinalityConstraint>();
        this.ccCounter = 0;
        this.pbCounter = 0;
        this.cnfCounter = 0;
    }

    public String name() {
        return this.name;
    }

    public Configuration configurationFor(ConfigurationType cType) {
        return this.configurations.get((Object)cType);
    }

    public void putConfiguration(Configuration configuration) {
        if (configuration.type() == ConfigurationType.FORMULA_FACTORY) {
            throw new IllegalArgumentException("Configurations for the formula factory itself can only be passed in the constructor.");
        }
        this.configurations.put(configuration.type(), configuration);
    }

    public SubNodeFunction subformulaFunction() {
        return this.subformulaFunction;
    }

    public PBEncoder pbEncoder() {
        return this.pbEncoder;
    }

    public CNFEncoder cnfEncoder() {
        return this.cnfEncoder;
    }

    public Formula binaryOperator(FType type, Formula left, Formula right) {
        switch (type) {
            case IMPL: {
                return this.implication(left, right);
            }
            case EQUIV: {
                return this.equivalence(left, right);
            }
        }
        throw new IllegalArgumentException("Cannot create a binary formula with operator: " + (Object)((Object)type));
    }

    public Formula implication(Formula leftIn, Formula rightIn) {
        Formula left = this.importOrPanic(leftIn);
        Formula right = this.importOrPanic(rightIn);
        if (left.type() == FType.FALSE || right.type() == FType.TRUE) {
            return this.verum();
        }
        if (left.type() == FType.TRUE) {
            return right;
        }
        if (right.type() == FType.FALSE) {
            return this.not(left);
        }
        if (left.equals(right)) {
            return this.verum();
        }
        Pair<Formula, Formula> key = new Pair<Formula, Formula>(left, right);
        Implication implication = this.implications.get(key);
        if (implication == null) {
            implication = new Implication(left, right, this);
            this.implications.put(key, implication);
        }
        return implication;
    }

    public Formula equivalence(Formula leftIn, Formula rightIn) {
        Formula left = this.importOrPanic(leftIn);
        Formula right = this.importOrPanic(rightIn);
        if (left.type() == FType.TRUE) {
            return right;
        }
        if (right.type() == FType.TRUE) {
            return left;
        }
        if (left.type() == FType.FALSE) {
            return this.not(right);
        }
        if (right.type() == FType.FALSE) {
            return this.not(left);
        }
        if (left.equals(right)) {
            return this.verum();
        }
        if (left.equals(right.negate())) {
            return this.falsum();
        }
        LinkedHashSet<Formula> key = new LinkedHashSet<Formula>(Arrays.asList(left, right));
        Equivalence equivalence = this.equivalences.get(key);
        if (equivalence == null) {
            equivalence = new Equivalence(left, right, this);
            this.equivalences.put(key, equivalence);
        }
        return equivalence;
    }

    public CTrue verum() {
        return this.cTrue;
    }

    public Formula not(Formula operandIn) {
        Formula operand = this.importOrPanic(operandIn);
        if (operand.type() == FType.LITERAL || operand.type() == FType.FALSE || operand.type() == FType.TRUE || operand.type() == FType.NOT) {
            return operand.negate();
        }
        Not not = this.nots.get(operand);
        if (not == null) {
            not = new Not(operand, this);
            this.nots.put(operand, not);
        }
        return not;
    }

    public CFalse falsum() {
        return this.cFalse;
    }

    public Constant constant(boolean value) {
        return value ? this.cTrue : this.cFalse;
    }

    public Formula naryOperator(FType type, Collection<? extends Formula> operands) {
        return this.naryOperator(type, operands.toArray(new Formula[0]));
    }

    public Formula naryOperator(FType type, Formula ... operands) {
        switch (type) {
            case OR: {
                return this.or(operands);
            }
            case AND: {
                return this.and(operands);
            }
        }
        throw new IllegalArgumentException("Cannot create an n-ary formula with operator: " + (Object)((Object)type));
    }

    public Formula and(Formula ... operands) {
        LinkedHashSet ops = new LinkedHashSet(operands.length);
        Collections.addAll(ops, operands);
        return this.constructAnd(ops);
    }

    public Formula and(Collection<? extends Formula> operands) {
        LinkedHashSet<? extends Formula> ops = new LinkedHashSet<Formula>(operands);
        return this.constructAnd(ops);
    }

    private Formula importOrPanic(Formula formula) {
        if (formula.factory() == this) {
            return formula;
        }
        switch (this.formulaMergeStrategy) {
            case IMPORT: {
                return this.importFormula(formula);
            }
            case PANIC: {
                throw new UnsupportedOperationException("Found an operand with a different formula factory.");
            }
        }
        throw new IllegalStateException("Unknown formula merge strategy: " + (Object)((Object)this.formulaMergeStrategy));
    }

    private LinkedHashSet<? extends Formula> importOrPanic(LinkedHashSet<? extends Formula> formulas) {
        boolean foundAnotherFormulaFactory = false;
        for (Formula formula : formulas) {
            if (formula.factory() == this) continue;
            foundAnotherFormulaFactory = true;
            break;
        }
        if (!foundAnotherFormulaFactory) {
            return formulas;
        }
        switch (this.formulaMergeStrategy) {
            case IMPORT: {
                LinkedHashSet<Formula> result = new LinkedHashSet<Formula>();
                for (Formula formula : formulas) {
                    result.add(formula.factory() != this ? this.importFormula(formula) : formula);
                }
                return result;
            }
            case PANIC: {
                throw new UnsupportedOperationException("Found an operand with a different formula factory.");
            }
        }
        throw new IllegalStateException("Unknown formula merge strategy: " + (Object)((Object)this.formulaMergeStrategy));
    }

    private Literal[] importOrPanic(Literal[] literals) {
        boolean foundAnotherFormulaFactory = false;
        for (Literal lit : literals) {
            if (lit.factory() == this) continue;
            foundAnotherFormulaFactory = true;
            break;
        }
        if (!foundAnotherFormulaFactory) {
            return literals;
        }
        switch (this.formulaMergeStrategy) {
            case IMPORT: {
                Literal[] result = new Literal[literals.length];
                for (int i = 0; i < literals.length; ++i) {
                    Literal lit = literals[i];
                    result[i] = lit.factory() != this ? this.literal(lit.name(), lit.phase()) : lit;
                }
                return result;
            }
            case PANIC: {
                throw new UnsupportedOperationException("Found an operand with a different formula factory.");
            }
        }
        throw new IllegalStateException("Unknown formula merge strategy: " + (Object)((Object)this.formulaMergeStrategy));
    }

    private Formula constructAnd(LinkedHashSet<? extends Formula> operandsIn) {
        LinkedHashSet<? extends Formula> condensedOperands;
        LinkedHashSet<? extends Formula> operands = this.importOrPanic(operandsIn);
        And tempAnd = null;
        Map<LinkedHashSet<? extends Formula>, And> opAndMap = this.andsN;
        if (operands.size() > 1) {
            switch (operands.size()) {
                case 2: {
                    opAndMap = this.ands2;
                    break;
                }
                case 3: {
                    opAndMap = this.ands3;
                    break;
                }
                case 4: {
                    opAndMap = this.ands4;
                    break;
                }
            }
            tempAnd = opAndMap.get(operands);
        }
        if (tempAnd != null) {
            return tempAnd;
        }
        LinkedHashSet<? extends Formula> linkedHashSet = condensedOperands = operands.size() < 2 ? operands : this.condenseOperandsAnd(operands);
        if (condensedOperands == null) {
            return this.falsum();
        }
        if (condensedOperands.isEmpty()) {
            return this.verum();
        }
        if (condensedOperands.size() == 1) {
            return (Formula)condensedOperands.iterator().next();
        }
        Map<LinkedHashSet<? extends Formula>, And> condAndMap = this.andsN;
        switch (condensedOperands.size()) {
            case 2: {
                condAndMap = this.ands2;
                break;
            }
            case 3: {
                condAndMap = this.ands3;
                break;
            }
            case 4: {
                condAndMap = this.ands4;
                break;
            }
        }
        And and = condAndMap.get(condensedOperands);
        if (and == null) {
            tempAnd = new And(condensedOperands, this, this.cnfCheck);
            opAndMap.put(operands, tempAnd);
            condAndMap.put(condensedOperands, tempAnd);
            return tempAnd;
        }
        opAndMap.put(operands, and);
        return and;
    }

    public Formula cnf(Formula ... clauses) {
        LinkedHashSet ops = new LinkedHashSet(clauses.length);
        Collections.addAll(ops, clauses);
        return this.constructCNF(ops);
    }

    public Formula cnf(Collection<? extends Formula> clauses) {
        LinkedHashSet<? extends Formula> ops = new LinkedHashSet<Formula>(clauses);
        return this.constructCNF(ops);
    }

    private Formula constructCNF(LinkedHashSet<? extends Formula> clausesIn) {
        LinkedHashSet<? extends Formula> clauses = this.importOrPanic(clausesIn);
        if (clauses.isEmpty()) {
            return this.verum();
        }
        if (clauses.size() == 1) {
            return (Formula)clauses.iterator().next();
        }
        Map<LinkedHashSet<? extends Formula>, And> opAndMap = this.andsN;
        switch (clauses.size()) {
            case 2: {
                opAndMap = this.ands2;
                break;
            }
            case 3: {
                opAndMap = this.ands3;
                break;
            }
            case 4: {
                opAndMap = this.ands4;
                break;
            }
        }
        And tempAnd = opAndMap.get(clauses);
        if (tempAnd != null) {
            return tempAnd;
        }
        tempAnd = new And(clauses, this, true);
        opAndMap.put(clauses, tempAnd);
        return tempAnd;
    }

    public Formula or(Formula ... operands) {
        LinkedHashSet ops = new LinkedHashSet(operands.length);
        Collections.addAll(ops, operands);
        return this.constructOr(ops);
    }

    public Formula or(Collection<? extends Formula> operands) {
        LinkedHashSet<? extends Formula> ops = new LinkedHashSet<Formula>(operands);
        return this.constructOr(ops);
    }

    private Formula constructOr(LinkedHashSet<? extends Formula> operandsIn) {
        LinkedHashSet<? extends Formula> condensedOperands;
        LinkedHashSet<? extends Formula> operands = this.importOrPanic(operandsIn);
        Or tempOr = null;
        Map<LinkedHashSet<? extends Formula>, Or> opOrMap = this.orsN;
        if (operands.size() > 1) {
            switch (operands.size()) {
                case 2: {
                    opOrMap = this.ors2;
                    break;
                }
                case 3: {
                    opOrMap = this.ors3;
                    break;
                }
                case 4: {
                    opOrMap = this.ors4;
                    break;
                }
            }
            tempOr = opOrMap.get(operands);
        }
        if (tempOr != null) {
            return tempOr;
        }
        LinkedHashSet<? extends Formula> linkedHashSet = condensedOperands = operands.size() < 2 ? operands : this.condenseOperandsOr(operands);
        if (condensedOperands == null) {
            return this.verum();
        }
        if (condensedOperands.isEmpty()) {
            return this.falsum();
        }
        if (condensedOperands.size() == 1) {
            return (Formula)condensedOperands.iterator().next();
        }
        Map<LinkedHashSet<? extends Formula>, Or> condOrMap = this.orsN;
        switch (condensedOperands.size()) {
            case 2: {
                condOrMap = this.ors2;
                break;
            }
            case 3: {
                condOrMap = this.ors3;
                break;
            }
            case 4: {
                condOrMap = this.ors4;
                break;
            }
        }
        Or or = condOrMap.get(condensedOperands);
        if (or == null) {
            tempOr = new Or(condensedOperands, this, this.cnfCheck);
            opOrMap.put(operands, tempOr);
            condOrMap.put(condensedOperands, tempOr);
            return tempOr;
        }
        opOrMap.put(operands, or);
        return or;
    }

    public Formula clause(Literal ... literals) {
        LinkedHashSet<Literal> ops = new LinkedHashSet<Literal>(literals.length);
        Collections.addAll(ops, literals);
        return this.constructClause(ops);
    }

    public Formula clause(Collection<? extends Literal> literals) {
        LinkedHashSet<Literal> ops = new LinkedHashSet<Literal>(literals);
        return this.constructClause(ops);
    }

    private Formula constructClause(LinkedHashSet<Literal> literalsIn) {
        LinkedHashSet<? extends Formula> literals = this.importOrPanic(literalsIn);
        if (literals.isEmpty()) {
            return this.falsum();
        }
        if (literals.size() == 1) {
            return (Formula)literals.iterator().next();
        }
        Map<LinkedHashSet<? extends Formula>, Or> opOrMap = this.orsN;
        switch (literals.size()) {
            case 2: {
                opOrMap = this.ors2;
                break;
            }
            case 3: {
                opOrMap = this.ors3;
                break;
            }
            case 4: {
                opOrMap = this.ors4;
                break;
            }
        }
        Or tempOr = opOrMap.get(literals);
        if (tempOr != null) {
            return tempOr;
        }
        tempOr = new Or(literals, this, true);
        opOrMap.put(literals, tempOr);
        return tempOr;
    }

    public Literal literal(String name, boolean phase) {
        if (phase) {
            return this.variable(name);
        }
        Literal lit = this.negLiterals.get(name);
        if (lit == null) {
            lit = new Literal(name, false, this);
            this.negLiterals.put(name, lit);
        }
        return lit;
    }

    public Variable variable(String name) {
        Variable var = this.posLiterals.get(name);
        if (var == null) {
            var = new Variable(name, this);
            this.posLiterals.put(name, var);
        }
        return var;
    }

    public Formula pbc(CType comparator, int rhs, List<? extends Literal> literals, List<Integer> coefficients) {
        int[] cfs = new int[coefficients.size()];
        for (int i = 0; i < coefficients.size(); ++i) {
            cfs[i] = coefficients.get(i);
        }
        return this.constructPBC(comparator, rhs, literals.toArray(new Literal[0]), cfs);
    }

    public Formula pbc(CType comparator, int rhs, Literal[] literals, int[] coefficients) {
        return this.constructPBC(comparator, rhs, Arrays.copyOf(literals, literals.length), Arrays.copyOf(coefficients, coefficients.length));
    }

    private Formula constructPBC(CType comparator, int rhs, Literal[] literalsIn, int[] coefficients) {
        Literal[] literals = this.importOrPanic(literalsIn);
        if (literals.length == 0) {
            return this.constant(FormulaFactory.evaluateTrivialPBConstraint(comparator, rhs));
        }
        if (FormulaFactory.isCC(comparator, rhs, literals, coefficients)) {
            return this.constructCCUnsafe(comparator, rhs, literals);
        }
        PBOperands operands = new PBOperands(literals, coefficients, comparator, rhs);
        PBConstraint constraint = this.pbConstraints.get(operands);
        if (constraint == null) {
            constraint = new PBConstraint(literals, coefficients, comparator, rhs, this);
            this.pbConstraints.put(operands, constraint);
        }
        return constraint;
    }

    public Formula cc(CType comparator, int rhs, Collection<Variable> variables) {
        Literal[] vars = new Variable[variables.size()];
        int count = 0;
        for (Variable var : variables) {
            vars[count++] = var;
        }
        return this.constructCC(comparator, rhs, vars);
    }

    public Formula cc(CType comparator, int rhs, Variable ... variables) {
        Literal[] vars = new Variable[variables.length];
        int count = 0;
        for (Variable var : variables) {
            vars[count++] = var;
        }
        return this.constructCC(comparator, rhs, vars);
    }

    public Formula amo(Collection<Variable> variables) {
        Literal[] vars = new Variable[variables.size()];
        int count = 0;
        for (Variable var : variables) {
            vars[count++] = var;
        }
        return this.constructCCUnsafe(CType.LE, 1, vars);
    }

    public Formula amo(Variable ... variables) {
        return this.constructCCUnsafe(CType.LE, 1, variables);
    }

    public Formula exo(Collection<Variable> variables) {
        Literal[] vars = new Variable[variables.size()];
        int count = 0;
        for (Variable var : variables) {
            vars[count++] = var;
        }
        return this.constructCCUnsafe(CType.EQ, 1, vars);
    }

    public Formula exo(Variable ... variables) {
        return this.constructCCUnsafe(CType.EQ, 1, variables);
    }

    private Formula constructCC(CType comparator, int rhs, Literal[] literals) {
        if (!FormulaFactory.isCC(comparator, rhs, literals, null)) {
            throw new IllegalArgumentException("Given values do not represent a cardinality constraint.");
        }
        return this.constructCCUnsafe(comparator, rhs, literals);
    }

    private Formula constructCCUnsafe(CType comparator, int rhs, Literal[] literalsIn) {
        Literal[] literals = this.importOrPanic(literalsIn);
        if (literals.length == 0) {
            return this.constant(FormulaFactory.evaluateTrivialPBConstraint(comparator, rhs));
        }
        CCOperands operands = new CCOperands(literals, comparator, rhs);
        CardinalityConstraint constraint = this.cardinalityConstraints.get(operands);
        if (constraint == null) {
            constraint = new CardinalityConstraint(this.importOrPanic(literals), comparator, rhs, this);
            this.cardinalityConstraints.put(operands, constraint);
        }
        return constraint;
    }

    private static boolean isCC(CType comparator, int rhs, Literal[] literals, int[] coefficients) {
        for (Literal lit : literals) {
            if (lit.phase()) continue;
            return false;
        }
        if (coefficients != null) {
            for (int c : coefficients) {
                if (c == 1) continue;
                return false;
            }
        }
        return comparator == CType.LE && rhs >= 0 || comparator == CType.LT && rhs >= 1 || comparator == CType.GE && rhs >= 0 || comparator == CType.GT && rhs >= -1 || comparator == CType.EQ && rhs >= 0;
    }

    private static boolean evaluateTrivialPBConstraint(CType comparator, int rhs) {
        switch (comparator) {
            case EQ: {
                return rhs == 0;
            }
            case LE: {
                return rhs >= 0;
            }
            case LT: {
                return rhs > 0;
            }
            case GE: {
                return rhs <= 0;
            }
            case GT: {
                return rhs < 0;
            }
        }
        throw new IllegalArgumentException("Unknown comparator: " + (Object)((Object)comparator));
    }

    public Variable newCCVariable() {
        Variable var = this.variable(this.ccPrefix + this.ccCounter++);
        this.generatedVariables.add(var);
        return var;
    }

    public Variable newPBVariable() {
        Variable var = this.variable(this.pbPrefix + this.pbCounter++);
        this.generatedVariables.add(var);
        return var;
    }

    public Variable newCNFVariable() {
        Variable var = this.variable(this.cnfPrefix + this.cnfCounter++);
        this.generatedVariables.add(var);
        return var;
    }

    private LinkedHashSet<Formula> condenseOperandsOr(Collection<? extends Formula> operands) {
        LinkedHashSet<Formula> ops = new LinkedHashSet<Formula>();
        this.cnfCheck = true;
        for (Formula formula : operands) {
            if (formula.type() == FType.OR) {
                for (Formula f : ((NAryOperator)formula).operands) {
                    byte ret = this.addFormulaOr(ops, f);
                    if (ret == 0) {
                        return null;
                    }
                    if (ret != 2) continue;
                    this.cnfCheck = false;
                }
                continue;
            }
            byte ret = this.addFormulaOr(ops, formula);
            if (ret == 0) {
                return null;
            }
            if (ret != 2) continue;
            this.cnfCheck = false;
        }
        return ops;
    }

    private LinkedHashSet<Formula> condenseOperandsAnd(Collection<? extends Formula> operands) {
        LinkedHashSet<Formula> ops = new LinkedHashSet<Formula>();
        this.cnfCheck = true;
        for (Formula formula : operands) {
            if (formula.type() == FType.AND) {
                for (Formula f : ((NAryOperator)formula).operands) {
                    byte ret = this.addFormulaAnd(ops, f);
                    if (ret == 0) {
                        return null;
                    }
                    if (ret != 2) continue;
                    this.cnfCheck = false;
                }
                continue;
            }
            byte ret = this.addFormulaAnd(ops, formula);
            if (ret == 0) {
                return null;
            }
            if (ret != 2) continue;
            this.cnfCheck = false;
        }
        return ops;
    }

    public boolean isGeneratedVariable(Variable var) {
        return this.generatedVariables.contains(var);
    }

    public long numberOfNodes(Formula formula) {
        return formula.apply(this.subformulaFunction).size();
    }

    public Formula parse(String string) throws ParserException {
        return this.parser.parse(string);
    }

    private byte addFormulaOr(LinkedHashSet<Formula> ops, Formula f) {
        if (f.type == FType.FALSE) {
            return 1;
        }
        if (f.type == FType.TRUE || this.containsComplement(ops, f)) {
            return 0;
        }
        ops.add(f);
        return (byte)(f.type == FType.LITERAL ? 1 : 2);
    }

    private byte addFormulaAnd(LinkedHashSet<Formula> ops, Formula f) {
        if (f.type() == FType.TRUE) {
            return 1;
        }
        if (f.type == FType.FALSE || this.containsComplement(ops, f)) {
            return 0;
        }
        ops.add(f);
        return (byte)(f.type == FType.LITERAL || f.type == FType.OR && ((Or)f).isCNFClause() ? 1 : 2);
    }

    public Formula importFormula(Formula formula) {
        if (this.importer == null) {
            this.importer = new FormulaFactoryImporter(this);
        }
        Formula imported = formula.transform(this.importer);
        this.adjustCounters(imported);
        return imported;
    }

    private void adjustCounters(Formula formula) {
        for (Variable variable : formula.variables()) {
            String[] tokens;
            int counter;
            if (variable.name().startsWith(CC_PREFIX) && this.ccCounter < (counter = Integer.parseInt((tokens = variable.name().split("_"))[tokens.length - 1]))) {
                this.ccCounter = counter + 1;
            }
            if (variable.name().startsWith(CNF_PREFIX) && this.cnfCounter < (counter = Integer.parseInt((tokens = variable.name().split("_"))[tokens.length - 1]))) {
                this.cnfCounter = counter + 1;
            }
            if (!variable.name().startsWith(PB_PREFIX) || this.pbCounter >= (counter = Integer.parseInt((tokens = variable.name().split("_"))[tokens.length - 1]))) continue;
            this.pbCounter = counter + 1;
        }
    }

    public String string(Formula formula) {
        return this.stringRepresentation.toString(formula);
    }

    public String string(Formula formula, FormulaStringRepresentation stringRepresentation) {
        return stringRepresentation.toString(formula);
    }

    public FormulaStringRepresentation stringRepresentation() {
        return this.stringRepresentation;
    }

    public FormulaFactoryStatistics statistics() {
        FormulaFactoryStatistics statistics = new FormulaFactoryStatistics();
        statistics.name = this.name;
        statistics.positiveLiterals = this.posLiterals.size();
        statistics.negativeLiterals = this.negLiterals.size();
        statistics.negations = this.nots.size();
        statistics.implications = this.implications.size();
        statistics.equivalences = this.equivalences.size();
        statistics.conjunctions2 = this.ands2.size();
        statistics.conjunctions3 = this.ands3.size();
        statistics.conjunctions4 = this.ands4.size();
        statistics.conjunctionsN = this.andsN.size();
        statistics.disjunctions2 = this.ors2.size();
        statistics.disjunctions3 = this.ors3.size();
        statistics.disjunctions4 = this.ors4.size();
        statistics.disjunctionsN = this.orsN.size();
        statistics.pbcs = this.pbConstraints.size();
        statistics.ccs = this.cardinalityConstraints.size();
        statistics.ccCounter = this.ccCounter;
        statistics.pbCounter = this.pbCounter;
        statistics.cnfCounter = this.cnfCounter;
        return statistics;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name:              ").append(this.name).append(System.lineSeparator());
        sb.append("Positive Literals: ").append(this.posLiterals.size()).append(System.lineSeparator());
        sb.append("Negative Literals: ").append(this.negLiterals.size()).append(System.lineSeparator());
        sb.append("Negations:         ").append(this.nots.size()).append(System.lineSeparator());
        sb.append("Implications:      ").append(this.implications.size()).append(System.lineSeparator());
        sb.append("Equivalences:      ").append(this.equivalences.size()).append(System.lineSeparator());
        sb.append("Conjunctions (2):  ").append(this.ands2.size()).append(System.lineSeparator());
        sb.append("Conjunctions (3):  ").append(this.ands3.size()).append(System.lineSeparator());
        sb.append("Conjunctions (4):  ").append(this.ands4.size()).append(System.lineSeparator());
        sb.append("Conjunctions (>4): ").append(this.andsN.size()).append(System.lineSeparator());
        sb.append("Disjunctions (2):  ").append(this.ors2.size()).append(System.lineSeparator());
        sb.append("Disjunctions (3):  ").append(this.ors3.size()).append(System.lineSeparator());
        sb.append("Disjunctions (4):  ").append(this.ors4.size()).append(System.lineSeparator());
        sb.append("Disjunctions (>4): ").append(this.orsN.size()).append(System.lineSeparator());
        sb.append("Pseudo Booleans:   ").append(this.pbConstraints.size()).append(System.lineSeparator());
        sb.append("CCs:               ").append(this.cardinalityConstraints.size()).append(System.lineSeparator());
        return sb.toString();
    }

    public static final class FormulaFactoryStatistics {
        private String name;
        private int positiveLiterals;
        private int negativeLiterals;
        private int negations;
        private int implications;
        private int equivalences;
        private int conjunctions2;
        private int conjunctions3;
        private int conjunctions4;
        private int conjunctionsN;
        private int disjunctions2;
        private int disjunctions3;
        private int disjunctions4;
        private int disjunctionsN;
        private int pbcs;
        private int ccs;
        private int ccCounter;
        private int pbCounter;
        private int cnfCounter;

        public String name() {
            return this.name;
        }

        public int positiveLiterals() {
            return this.positiveLiterals;
        }

        public int negativeLiterals() {
            return this.negativeLiterals;
        }

        public int negations() {
            return this.negations;
        }

        public int implications() {
            return this.implications;
        }

        public int equivalences() {
            return this.equivalences;
        }

        public int conjunctions2() {
            return this.conjunctions2;
        }

        public int conjunctions3() {
            return this.conjunctions3;
        }

        public int conjunctions4() {
            return this.conjunctions4;
        }

        public int conjunctionsN() {
            return this.conjunctionsN;
        }

        public int disjunctions2() {
            return this.disjunctions2;
        }

        public int disjunctions3() {
            return this.disjunctions3;
        }

        public int disjunctions4() {
            return this.disjunctions4;
        }

        public int disjunctionsN() {
            return this.disjunctionsN;
        }

        public int pbcs() {
            return this.pbcs;
        }

        public int ccs() {
            return this.ccs;
        }

        public int ccCounter() {
            return this.ccCounter;
        }

        public int pbCounter() {
            return this.pbCounter;
        }

        public int cnfCounter() {
            return this.cnfCounter;
        }

        public int formulas() {
            return this.positiveLiterals + this.negativeLiterals + this.negations + this.implications + this.equivalences + this.conjunctions2 + this.conjunctions3 + this.conjunctions4 + this.conjunctionsN + this.disjunctions2 + this.disjunctions3 + this.disjunctions4 + this.disjunctionsN + this.pbcs + this.ccs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FormulaFactoryStatistics)) {
                return false;
            }
            FormulaFactoryStatistics that = (FormulaFactoryStatistics)o;
            return Objects.equals(this.name, that.name) && this.positiveLiterals == that.positiveLiterals && this.negativeLiterals == that.negativeLiterals && this.negations == that.negations && this.implications == that.implications && this.equivalences == that.equivalences && this.conjunctions2 == that.conjunctions2 && this.conjunctions3 == that.conjunctions3 && this.conjunctions4 == that.conjunctions4 && this.conjunctionsN == that.conjunctionsN && this.disjunctions2 == that.disjunctions2 && this.disjunctions3 == that.disjunctions3 && this.disjunctions4 == that.disjunctions4 && this.disjunctionsN == that.disjunctionsN && this.pbcs == that.pbcs && this.ccs == that.ccs && this.ccCounter == that.ccCounter && this.pbCounter == that.pbCounter && this.cnfCounter == that.cnfCounter;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.positiveLiterals, this.negativeLiterals, this.negations, this.implications, this.equivalences, this.conjunctions2, this.conjunctions3, this.conjunctions4, this.conjunctionsN, this.disjunctions2, this.disjunctions3, this.disjunctions4, this.disjunctionsN, this.pbcs, this.ccs, this.ccCounter, this.pbCounter, this.cnfCounter);
        }

        public String toString() {
            return "FormulaFactoryStatistics{name='" + this.name + '\'' + ", positiveLiterals=" + this.positiveLiterals + ", negativeLiterals=" + this.negativeLiterals + ", negations=" + this.negations + ", implications=" + this.implications + ", equivalences=" + this.equivalences + ", conjunctions2=" + this.conjunctions2 + ", conjunctions3=" + this.conjunctions3 + ", conjunctions4=" + this.conjunctions4 + ", conjunctionsN=" + this.conjunctionsN + ", disjunctions2=" + this.disjunctions2 + ", disjunctions3=" + this.disjunctions3 + ", disjunctions4=" + this.disjunctions4 + ", disjunctionsN=" + this.disjunctionsN + ", pbcs=" + this.pbcs + ", ccs=" + this.ccs + ", ccCounter=" + this.ccCounter + ", pbCounter=" + this.pbCounter + ", cnfCounter=" + this.cnfCounter + '}';
        }
    }

    private static final class CCOperands {
        private final Literal[] literals;
        private final CType comparator;
        private final int rhs;

        public CCOperands(Literal[] literals, CType comparator, int rhs) {
            this.literals = literals;
            this.comparator = comparator;
            this.rhs = rhs;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.rhs, this.comparator, Arrays.hashCode(this.literals)});
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof CCOperands) {
                CCOperands o = (CCOperands)other;
                return this.rhs == o.rhs && this.comparator == o.comparator && Arrays.equals(this.literals, o.literals);
            }
            return false;
        }
    }

    private static final class PBOperands {
        private final Literal[] literals;
        private final int[] coefficients;
        private final CType comparator;
        private final int rhs;

        public PBOperands(Literal[] literals, int[] coefficients, CType comparator, int rhs) {
            this.literals = literals;
            this.coefficients = coefficients;
            this.comparator = comparator;
            this.rhs = rhs;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.rhs, this.comparator, Arrays.hashCode(this.coefficients), Arrays.hashCode(this.literals)});
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof PBOperands) {
                PBOperands o = (PBOperands)other;
                return this.rhs == o.rhs && this.comparator == o.comparator && Arrays.equals(this.coefficients, o.coefficients) && Arrays.equals(this.literals, o.literals);
            }
            return false;
        }
    }
}

