/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Substitution;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.FType;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaFunction;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.knowledgecompilation.bdds.BDD;
import org.logicng.knowledgecompilation.bdds.BDDFactory;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;
import org.logicng.knowledgecompilation.bdds.orderings.VariableOrdering;
import org.logicng.knowledgecompilation.bdds.orderings.VariableOrderingProvider;

public abstract class Formula
implements Iterable<Formula> {
    protected final FType type;
    protected final FormulaFactory f;
    protected final Map<CacheEntry, Formula> transformationCache;
    protected final Map<CacheEntry, Tristate> predicateCache;
    protected final Map<CacheEntry, Object> functionCache;
    protected SortedSet<Variable> variables;
    protected long numberOfAtoms;
    protected long numberOfNodes;

    protected Formula(FType type, FormulaFactory f) {
        this.type = type;
        this.f = f;
        this.transformationCache = new HashMap<CacheEntry, Formula>();
        this.predicateCache = new HashMap<CacheEntry, Tristate>();
        this.functionCache = new HashMap<CacheEntry, Object>();
        this.variables = null;
        this.numberOfAtoms = -1L;
        this.numberOfNodes = -1L;
    }

    public FType type() {
        return this.type;
    }

    public FormulaFactory factory() {
        return this.f;
    }

    public abstract long numberOfAtoms();

    public abstract long numberOfNodes();

    public abstract int numberOfOperands();

    public long numberOfInternalNodes() {
        return this.f.numberOfNodes(this);
    }

    public abstract boolean isConstantFormula();

    public abstract boolean isAtomicFormula();

    public abstract SortedSet<Variable> variables();

    public abstract SortedSet<Literal> literals();

    public boolean containsVariable(String variable) {
        return this.containsVariable(this.f.variable(variable));
    }

    public abstract boolean containsVariable(Variable var1);

    public abstract boolean evaluate(Assignment var1);

    public abstract Formula restrict(Assignment var1);

    public abstract boolean containsNode(Formula var1);

    public Formula substitute(Variable variable, Formula formula) {
        Substitution subst = new Substitution();
        subst.addMapping(variable, formula);
        return this.substitute(subst);
    }

    public abstract Formula substitute(Substitution var1);

    public abstract Formula negate();

    public abstract Formula nnf();

    public Formula cnf() {
        return this.f.cnfEncoder().encode(this);
    }

    public BDD bdd(VariableOrdering variableOrdering) {
        BDDKernel kernel;
        int varNum = this.variables().size();
        if (variableOrdering == null) {
            kernel = new BDDKernel(this.factory(), varNum, varNum * 30, varNum * 20);
        } else {
            VariableOrderingProvider provider = variableOrdering.provider();
            kernel = new BDDKernel(this.f, provider.getOrder(this), varNum * 30, varNum * 20);
        }
        return BDDFactory.build(this, kernel, null);
    }

    public BDD bdd() {
        return this.bdd(null);
    }

    public Formula transform(FormulaTransformation transformation) {
        return transformation.apply(this, true);
    }

    public Formula transform(FormulaTransformation transformation, boolean cache) {
        return transformation.apply(this, cache);
    }

    public boolean holds(FormulaPredicate predicate) {
        return predicate.test(this, true);
    }

    public boolean holds(FormulaPredicate predicate, boolean cache) {
        return predicate.test(this, cache);
    }

    public <T> T apply(FormulaFunction<T> function, boolean cache) {
        return function.apply(this, cache);
    }

    public <T> T apply(FormulaFunction<T> function) {
        return function.apply(this, true);
    }

    public Formula transformationCacheEntry(CacheEntry key) {
        return this.transformationCache.get(key);
    }

    public void setTransformationCacheEntry(CacheEntry key, Formula value) {
        this.transformationCache.put(key, value);
    }

    public Tristate predicateCacheEntry(CacheEntry key) {
        Tristate tristate = this.predicateCache.get(key);
        if (tristate == null) {
            return Tristate.UNDEF;
        }
        return tristate;
    }

    public void setPredicateCacheEntry(CacheEntry key, boolean value) {
        this.predicateCache.put(key, Tristate.fromBool(value));
    }

    public void setPredicateCacheEntry(CacheEntry key, Tristate value) {
        this.predicateCache.put(key, value);
    }

    public Object functionCacheEntry(CacheEntry key) {
        return this.functionCache.get(key);
    }

    public void setFunctionCacheEntry(CacheEntry key, Object value) {
        this.functionCache.put(key, value);
    }

    public void clearCaches() {
        this.transformationCache.clear();
        this.functionCache.clear();
    }

    public abstract Stream<Formula> stream();

    public String toString() {
        return this.f.string(this);
    }
}

