/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.logicng.collections.LNGIntVector;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaFactoryState;

public class ExtendedFormulaFactory
extends FormulaFactory {
    private final LNGIntVector validStates = new LNGIntVector();
    private int nextStateId;

    static <T, U> void shrinkMap(Map<T, U> map, int newSize) {
        if (!(map instanceof LinkedHashMap)) {
            throw new IllegalStateException("Cannot shrink a map which is not of type LinkedHashMap");
        }
        if (newSize > map.size()) {
            throw new IllegalStateException("Cannot shrink a map of size " + map.size() + " to new size " + newSize);
        }
        Iterator<Map.Entry<T, U>> entryIterator = map.entrySet().iterator();
        for (int count = 0; count < newSize; ++count) {
            entryIterator.next();
        }
        while (entryIterator.hasNext()) {
            entryIterator.next();
            entryIterator.remove();
        }
    }

    static <T> void shrinkSet(Set<T> set, int newSize) {
        if (!(set instanceof LinkedHashSet)) {
            throw new IllegalStateException("Cannot shrink a set which is not of type LinkedHashSet");
        }
        if (newSize > set.size()) {
            throw new IllegalStateException("Cannot shrink a set of size " + set.size() + " to new size " + newSize);
        }
        Iterator<T> entryIterator = set.iterator();
        for (int count = 0; count < newSize; ++count) {
            entryIterator.next();
        }
        while (entryIterator.hasNext()) {
            entryIterator.next();
            entryIterator.remove();
        }
    }

    @Override
    public void clear() {
        this.posLiterals = new LinkedHashMap();
        this.negLiterals = new LinkedHashMap();
        this.generatedVariables = new LinkedHashSet();
        this.nots = new LinkedHashMap();
        this.implications = new LinkedHashMap();
        this.equivalences = new LinkedHashMap();
        this.ands2 = new LinkedHashMap();
        this.ands3 = new LinkedHashMap();
        this.ands4 = new LinkedHashMap();
        this.andsN = new LinkedHashMap();
        this.ors2 = new LinkedHashMap();
        this.ors3 = new LinkedHashMap();
        this.ors4 = new LinkedHashMap();
        this.orsN = new LinkedHashMap();
        this.pbConstraints = new LinkedHashMap();
        this.cardinalityConstraints = new LinkedHashMap();
        this.ccCounter = 0;
        this.pbCounter = 0;
        this.cnfCounter = 0;
    }

    public FormulaFactoryState save() {
        int[] state = new int[]{this.posLiterals.size(), this.negLiterals.size(), this.generatedVariables.size(), this.nots.size(), this.implications.size(), this.equivalences.size(), this.ands2.size(), this.ands3.size(), this.ands4.size(), this.andsN.size(), this.ors2.size(), this.ors3.size(), this.ors4.size(), this.orsN.size(), this.pbConstraints.size(), this.cardinalityConstraints.size(), this.ccCounter, this.pbCounter, this.cnfCounter};
        int id = this.nextStateId++;
        this.validStates.push(id);
        return new FormulaFactoryState(id, state);
    }

    public void load(FormulaFactoryState state) {
        int index = -1;
        for (int i = this.validStates.size() - 1; i >= 0 && index == -1; --i) {
            if (this.validStates.get(i) != state.id()) continue;
            index = i;
        }
        if (index == -1) {
            throw new IllegalArgumentException("The given formula factory state is not valid anymore.");
        }
        this.validStates.shrinkTo(index + 1);
        ExtendedFormulaFactory.shrinkMap(this.posLiterals, state.state()[0]);
        ExtendedFormulaFactory.shrinkMap(this.negLiterals, state.state()[1]);
        ExtendedFormulaFactory.shrinkSet(this.generatedVariables, state.state()[2]);
        ExtendedFormulaFactory.shrinkMap(this.nots, state.state()[3]);
        ExtendedFormulaFactory.shrinkMap(this.implications, state.state()[4]);
        ExtendedFormulaFactory.shrinkMap(this.equivalences, state.state()[5]);
        ExtendedFormulaFactory.shrinkMap(this.ands2, state.state()[6]);
        ExtendedFormulaFactory.shrinkMap(this.ands3, state.state()[7]);
        ExtendedFormulaFactory.shrinkMap(this.ands4, state.state()[8]);
        ExtendedFormulaFactory.shrinkMap(this.andsN, state.state()[9]);
        ExtendedFormulaFactory.shrinkMap(this.ors2, state.state()[10]);
        ExtendedFormulaFactory.shrinkMap(this.ors3, state.state()[11]);
        ExtendedFormulaFactory.shrinkMap(this.ors4, state.state()[12]);
        ExtendedFormulaFactory.shrinkMap(this.orsN, state.state()[13]);
        ExtendedFormulaFactory.shrinkMap(this.pbConstraints, state.state()[14]);
        ExtendedFormulaFactory.shrinkMap(this.cardinalityConstraints, state.state()[15]);
        this.ccCounter = state.state()[16];
        this.pbCounter = state.state()[17];
        this.cnfCounter = state.state()[18];
        this.clearCaches();
    }

    private void clearCaches() {
        for (Formula formula : this.posLiterals.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.negLiterals.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.generatedVariables) {
            formula.clearCaches();
        }
        for (Formula formula : this.nots.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.implications.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.equivalences.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.ands2.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.ands3.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.ands4.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.andsN.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.ors2.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.ors3.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.ors4.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.orsN.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.pbConstraints.values()) {
            formula.clearCaches();
        }
        for (Formula formula : this.cardinalityConstraints.values()) {
            formula.clearCaches();
        }
    }
}

