/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import org.logicng.datastructures.Assignment;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.cache.TransformationCacheEntry;

public final class Equivalence
extends BinaryOperator {
    Equivalence(Formula left, Formula right, FormulaFactory f) {
        super(FType.EQUIV, left, right, f);
    }

    @Override
    public boolean evaluate(Assignment assignment) {
        return this.left.evaluate(assignment) == this.right.evaluate(assignment);
    }

    @Override
    public Formula restrict(Assignment assignment) {
        return this.f.equivalence(this.left.restrict(assignment), this.right.restrict(assignment));
    }

    @Override
    public Formula nnf() {
        Formula nnf = (Formula)this.transformationCache.get(TransformationCacheEntry.NNF);
        if (nnf == null) {
            nnf = this.f.and(this.f.or(this.f.not(this.left).nnf(), this.right.nnf()), this.f.or(this.f.not(this.right).nnf(), this.left.nnf()));
            this.transformationCache.put(TransformationCacheEntry.NNF, nnf);
        }
        return nnf;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 41 * (this.left.hashCode() + this.right.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Formula && this.f == ((Formula)other).f) {
            return false;
        }
        if (other instanceof Equivalence) {
            Equivalence otherEq = (Equivalence)other;
            return this.left.equals(otherEq.left) && this.right.equals(otherEq.right) || this.left.equals(otherEq.right) && this.right.equals(otherEq.left);
        }
        return false;
    }
}

