/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Substitution;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public abstract class Constant
extends Formula {
    private static final SortedSet<Variable> EMPTY_VARIABLE_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private static final SortedSet<Literal> EMPTY_LITERAL_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Iterator<Formula> ITERATOR = new Iterator<Formula>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Formula next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    Constant(FType type, FormulaFactory factory) {
        super(type, factory);
    }

    @Override
    public long numberOfAtoms() {
        return 1L;
    }

    @Override
    public long numberOfNodes() {
        return 1L;
    }

    @Override
    public int numberOfOperands() {
        return 0;
    }

    @Override
    public boolean isConstantFormula() {
        return true;
    }

    @Override
    public boolean isAtomicFormula() {
        return true;
    }

    @Override
    public SortedSet<Variable> variables() {
        return EMPTY_VARIABLE_SET;
    }

    @Override
    public SortedSet<Literal> literals() {
        return EMPTY_LITERAL_SET;
    }

    @Override
    public boolean containsVariable(Variable variable) {
        return false;
    }

    @Override
    public Formula restrict(Assignment assignment) {
        return this;
    }

    @Override
    public boolean containsNode(Formula formula) {
        return this == formula;
    }

    @Override
    public Formula substitute(Substitution substitution) {
        return this;
    }

    @Override
    public Formula nnf() {
        return this;
    }

    @Override
    public Iterator<Formula> iterator() {
        return ITERATOR;
    }

    @Override
    public Stream<Formula> stream() {
        return Stream.empty();
    }
}

