/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.Arrays;
import org.logicng.formulas.CType;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.PBConstraint;

public final class CardinalityConstraint
extends PBConstraint {
    private static int[] mkCoefficients(int length) {
        int[] coefficients = new int[length];
        Arrays.fill(coefficients, 1);
        return coefficients;
    }

    CardinalityConstraint(Literal[] literals, CType comparator, int rhs, FormulaFactory f) {
        super(literals, CardinalityConstraint.mkCoefficients(literals.length), comparator, rhs, f);
    }

    @Override
    public boolean isCC() {
        return true;
    }

    @Override
    public boolean isAmo() {
        return this.comparator == CType.LE && this.rhs == 1 || this.comparator == CType.LT && this.rhs == 2;
    }

    @Override
    public boolean isExo() {
        return this.comparator == CType.EQ && this.rhs == 1;
    }
}

