/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.logicng.datastructures.Substitution;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.util.FormulaHelper;

public abstract class BinaryOperator
extends Formula {
    protected final Formula left;
    protected final Formula right;
    protected volatile int hashCode;

    BinaryOperator(FType type, Formula left, Formula right, FormulaFactory f) {
        super(type, f);
        this.left = left;
        this.right = right;
        this.hashCode = 0;
    }

    public Formula left() {
        return this.left;
    }

    public Formula right() {
        return this.right;
    }

    @Override
    public long numberOfAtoms() {
        if (this.numberOfAtoms != -1L) {
            return this.numberOfAtoms;
        }
        this.numberOfAtoms = this.left.numberOfAtoms() + this.right.numberOfAtoms();
        return this.numberOfAtoms;
    }

    @Override
    public long numberOfNodes() {
        if (this.numberOfNodes != -1L) {
            return this.numberOfNodes;
        }
        this.numberOfNodes = this.left.numberOfNodes() + this.right.numberOfNodes() + 1L;
        return this.numberOfNodes;
    }

    @Override
    public int numberOfOperands() {
        return 2;
    }

    @Override
    public boolean isConstantFormula() {
        return false;
    }

    @Override
    public boolean isAtomicFormula() {
        return false;
    }

    @Override
    public SortedSet<Variable> variables() {
        if (this.variables == null) {
            this.variables = Collections.unmodifiableSortedSet(FormulaHelper.variables(this.left, this.right));
        }
        return this.variables;
    }

    @Override
    public SortedSet<Literal> literals() {
        return Collections.unmodifiableSortedSet(FormulaHelper.literals(this.left, this.right));
    }

    @Override
    public boolean containsVariable(Variable variable) {
        return this.left.containsVariable(variable) || this.right.containsVariable(variable);
    }

    @Override
    public boolean containsNode(Formula formula) {
        return this == formula || this.equals(formula) || this.left.containsNode(formula) || this.right.containsNode(formula);
    }

    @Override
    public Formula substitute(Substitution substitution) {
        return this.f.binaryOperator(this.type, this.left.substitute(substitution), this.right.substitute(substitution));
    }

    @Override
    public Formula negate() {
        return this.f.not(this);
    }

    @Override
    public Iterator<Formula> iterator() {
        return new Iterator<Formula>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < 2;
            }

            @Override
            public Formula next() {
                if (this.count == 0) {
                    ++this.count;
                    return BinaryOperator.this.left;
                }
                if (this.count == 1) {
                    ++this.count;
                    return BinaryOperator.this.right;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Stream<Formula> stream() {
        return Stream.of(this.left, this.right);
    }
}

