/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.formulas;

import java.util.LinkedHashSet;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.formulas.cache.PredicateCacheEntry;
import org.logicng.formulas.cache.TransformationCacheEntry;

public final class And
extends NAryOperator {
    And(LinkedHashSet<? extends Formula> operands, FormulaFactory f, boolean isCNF) {
        super(FType.AND, operands, f);
        if (isCNF) {
            this.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_CNF, true);
            this.setTransformationCacheEntry(TransformationCacheEntry.FACTORIZED_CNF, this);
        } else {
            this.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_CNF, false);
        }
    }

    @Override
    public boolean evaluate(Assignment assignment) {
        for (Formula op : this.operands) {
            if (op.evaluate(assignment)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode(31);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Formula && this.f == ((Formula)other).f) {
            return false;
        }
        if (other instanceof And) {
            return this.compareOperands(((And)other).operands);
        }
        return false;
    }
}

