/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.explanations.smus;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Variable;
import org.logicng.propositions.Proposition;
import org.logicng.propositions.StandardProposition;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SATSolver;
import org.logicng.solvers.SolverState;
import org.logicng.solvers.functions.OptimizationFunction;

public final class SmusComputation {
    private static final String PROPOSITION_SELECTOR = "@PROPOSITION_SEL_";

    private SmusComputation() {
    }

    public static <P extends Proposition> List<P> computeSmus(List<P> propositions, List<Formula> additionalConstraints, FormulaFactory f) {
        MiniSat growSolver = MiniSat.miniSat(f);
        growSolver.add(additionalConstraints == null ? Collections.singletonList(f.verum()) : additionalConstraints);
        TreeMap<Variable, Proposition> propositionMapping = new TreeMap<Variable, Proposition>();
        for (Proposition proposition : propositions) {
            Variable selector = f.variable(PROPOSITION_SELECTOR + propositionMapping.size());
            propositionMapping.put(selector, proposition);
            growSolver.add(f.equivalence(selector, proposition.formula()));
        }
        if (growSolver.sat(propositionMapping.keySet()) == Tristate.TRUE) {
            return null;
        }
        MiniSat hSolver = MiniSat.miniSat(f);
        while (true) {
            SortedSet<Variable> h;
            SortedSet<Variable> c;
            if ((c = SmusComputation.grow(growSolver, h = SmusComputation.minimumHs(hSolver, propositionMapping.keySet()), propositionMapping.keySet())) == null) {
                return h.stream().map(propositionMapping::get).collect(Collectors.toList());
            }
            hSolver.add(f.or(c));
        }
    }

    public static List<Formula> computeSmusForFormulas(List<Formula> formulas, List<Formula> additionalConstraints, FormulaFactory f) {
        List props = formulas.stream().map(StandardProposition::new).collect(Collectors.toList());
        List smus = SmusComputation.computeSmus(props, additionalConstraints, f);
        return smus == null ? null : smus.stream().map(Proposition::formula).collect(Collectors.toList());
    }

    private static SortedSet<Variable> minimumHs(SATSolver hSolver, Set<Variable> variables) {
        return new TreeSet<Variable>(hSolver.execute(OptimizationFunction.minimize(variables)).positiveVariables());
    }

    private static SortedSet<Variable> grow(SATSolver growSolver, SortedSet<Variable> h, Set<Variable> variables) {
        SolverState solverState = growSolver.saveState();
        growSolver.add(h);
        Assignment maxModel = growSolver.execute(OptimizationFunction.maximize(variables));
        if (maxModel == null) {
            return null;
        }
        List<Variable> maximumSatisfiableSet = maxModel.positiveVariables();
        growSolver.loadState(solverState);
        TreeSet<Variable> minimumCorrectionSet = new TreeSet<Variable>(variables);
        minimumCorrectionSet.removeAll(maximumSatisfiableSet);
        return minimumCorrectionSet;
    }
}

