/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.explanations.mus;

import java.util.ArrayList;
import java.util.List;
import org.logicng.datastructures.Tristate;
import org.logicng.explanations.UNSATCore;
import org.logicng.explanations.mus.MUSAlgorithm;
import org.logicng.explanations.mus.MUSConfig;
import org.logicng.formulas.FormulaFactory;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.MiniSat;

public class PlainInsertionBasedMUS
extends MUSAlgorithm {
    @Override
    public <T extends Proposition> UNSATCore<T> computeMUS(List<T> propositions, FormulaFactory f, MUSConfig config) {
        ArrayList<Object> currentFormula = new ArrayList<Object>(propositions.size());
        currentFormula.addAll(propositions);
        ArrayList<Proposition> mus = new ArrayList<Proposition>(propositions.size());
        MiniSat solver = MiniSat.miniSat(f);
        while (!currentFormula.isEmpty()) {
            ArrayList<Proposition> currentSubset = new ArrayList<Proposition>(propositions.size());
            Proposition transitionProposition = null;
            solver.reset();
            for (Proposition p : mus) {
                solver.add(p);
            }
            int count = currentFormula.size();
            while (solver.sat() == Tristate.TRUE) {
                if (count == 0) {
                    throw new IllegalArgumentException("Cannot compute a MUS for a satisfiable formula set.");
                }
                Proposition removeProposition = (Proposition)currentFormula.get(--count);
                currentSubset.add(removeProposition);
                transitionProposition = removeProposition;
                solver.add(removeProposition);
            }
            currentFormula.clear();
            currentFormula.addAll(currentSubset);
            if (transitionProposition == null) continue;
            currentFormula.remove(transitionProposition);
            mus.add(transitionProposition);
        }
        return new UNSATCore(mus, true);
    }
}

