/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.explanations.mus;

import java.util.List;
import org.logicng.explanations.UNSATCore;
import org.logicng.explanations.mus.DeletionBasedMUS;
import org.logicng.explanations.mus.MUSConfig;
import org.logicng.explanations.mus.PlainInsertionBasedMUS;
import org.logicng.formulas.FormulaFactory;
import org.logicng.propositions.Proposition;

public final class MUSGeneration {
    private final DeletionBasedMUS deletion = new DeletionBasedMUS();
    private final PlainInsertionBasedMUS insertion = new PlainInsertionBasedMUS();

    public <T extends Proposition> UNSATCore<T> computeMUS(List<T> propositions, FormulaFactory f) {
        return this.computeMUS(propositions, f, MUSConfig.builder().build());
    }

    public <T extends Proposition> UNSATCore<T> computeMUS(List<T> propositions, FormulaFactory f, MUSConfig config) {
        if (propositions.isEmpty()) {
            throw new IllegalArgumentException("Cannot generate a MUS for an empty list of propositions");
        }
        switch (config.algorithm) {
            case PLAIN_INSERTION: {
                return this.insertion.computeMUS(propositions, f, config);
            }
            case DELETION: {
                return this.deletion.computeMUS(propositions, f, config);
            }
        }
        throw new IllegalStateException("Unknown MUS algorithm: " + (Object)((Object)config.algorithm));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

