/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.explanations.mus;

import java.util.ArrayList;
import java.util.List;
import org.logicng.datastructures.Tristate;
import org.logicng.explanations.UNSATCore;
import org.logicng.explanations.mus.MUSAlgorithm;
import org.logicng.explanations.mus.MUSConfig;
import org.logicng.formulas.FormulaFactory;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SolverState;

public final class DeletionBasedMUS
extends MUSAlgorithm {
    @Override
    public <T extends Proposition> UNSATCore<T> computeMUS(List<T> propositions, FormulaFactory f, MUSConfig config) {
        ArrayList<T> mus = new ArrayList<T>(propositions.size());
        ArrayList<SolverState> solverStates = new ArrayList<SolverState>(propositions.size());
        MiniSat solver = MiniSat.miniSat(f);
        for (Proposition proposition : propositions) {
            solverStates.add(solver.saveState());
            solver.add(proposition);
        }
        if (solver.sat() != Tristate.FALSE) {
            throw new IllegalArgumentException("Cannot compute a MUS for a satisfiable formula set.");
        }
        for (int i = solverStates.size() - 1; i >= 0; --i) {
            solver.loadState((SolverState)solverStates.get(i));
            for (Proposition prop : mus) {
                solver.add(prop);
            }
            if (solver.sat() != Tristate.TRUE) continue;
            mus.add(propositions.get(i));
        }
        return new UNSATCore(mus, true);
    }
}

